/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.circulation;

import java.util.ArrayList;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTCirculationRequest;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTCirculationRequest;
import com.aimluck.eip.cayenne.om.security.auto._TurbineUser;
import com.aimluck.eip.circulation.util.CirculationUtils;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlConstants;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 回覧板の複数削除を行うためのクラスです。 <BR>
 * 
 */
public class CirculationMultiDelete extends ALAbstractCheckList {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(CirculationMultiDelete.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @param values
   * @param msgList
   * @return
   * @see com.aimluck.eip.common.ALAbstractCheckList#action(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList,
   *      java.util.ArrayList)
   */
  @Override
  protected boolean action(RunData rundata, Context context, ArrayList values,
      ArrayList msgList) {

    DataContext dataContext = DatabaseOrmService.getInstance()
    .getDataContext();
    
  	try {
      SelectQuery query = new SelectQuery(AvzTCirculationRequest.class);
      Expression exp1 = ExpressionFactory.matchDbExp(
          _TurbineUser.USER_ID_PK_COLUMN, Integer.valueOf(ALEipUtils
              .getUserId(rundata)));
      query.setQualifier(exp1);
      Expression exp2 = ExpressionFactory.inDbExp(_AvzTCirculationRequest.REQUEST_ID_PK_COLUMN,
          values);
      query.andQualifier(exp2);

      List avz_t_circulation_requestlist = dataContext.performQuery(query);
      if (avz_t_circulation_requestlist == null || avz_t_circulation_requestlist.size() == 0)
        return false;

      int avz_t_circulation_requestlistsize = avz_t_circulation_requestlist.size();
      for (int i = 0; i < avz_t_circulation_requestlistsize; i++) {
        AvzTCirculationRequest avz_t_circulation_request = (AvzTCirculationRequest) avz_t_circulation_requestlist.get(i);
        // avz_t_circulation_requestカテゴリを削除
        dataContext.deleteObject(avz_t_circulation_request);
        dataContext.commitChanges();
      }
      
    } catch (Exception ex) {
      logger.error("Exception", ex);
      dataContext.rollbackChanges();
      return false;
    }
    return true;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限を返します。
   * 
   * @return
   */
  @Override
  protected int getDefineAclType() {
    return ALAccessControlConstants.VALUE_ACL_DELETE;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }
}
