/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.lunchorder.LunchOrderPreViewResultData;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.util.ALEipUtils;

/**
 * プレビューデータを管理するクラスです。 <BR>
 * 
 */
public class LunchOrderPreViewSelectData extends ALAbstractSelectData implements
    ALData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderPreViewSelectData.class.getName());

  /** 弁当屋Id * */
  private String storeId;

  /** 弁当屋名 * */
  private ALStringField storeName;

  /** 弁当屋コメント * */
  private ALStringField storeComment;

  /** プレビュー画面に表示させるセッション情報を入れるリスト */
  private ArrayList<Object> preViewList;

  public void initField() {
    // 弁当屋名
    storeName = new ALStringField();
    // コメント
    storeComment = new ALStringField();

  }

  public void loadPreViewList(RunData rundata, Context context) {
    try {
      preViewList = new ArrayList<Object>();

      // 表示する各項目情報をセッションから取り出す
      // 弁当屋ID
      String sessionStoreId = new String(ALEipUtils.getTemp(rundata, context,
          "com.aimluck.eip.lunchorder.storeIdListKey"));
      storeId = sessionStoreId;
      // 弁当屋名
      String sessionStoreName = new String(ALEipUtils.getTemp(rundata, context,
          "com.aimluck.eip.lunchorder.storeNameListKey"));
      storeName.setValue(sessionStoreName);
      // 弁当屋コメント
      String sessionStoreComment = new String(ALEipUtils.getTemp(rundata,
          context, "com.aimluck.eip.lunchorder.storeCommentListKey"));
      storeComment.setValue(sessionStoreComment);
      // 商品ID
      String sessionItemId = new String(ALEipUtils.getTemp(rundata, context,
          "com.aimluck.eip.lunchorder.itemIdListKey"));
      String[] splitItemId = sessionItemId.split(",", -1);
      //itemId = sessionItemId;
      // 商品名
      String sessionItemName = new String(ALEipUtils.getTemp(rundata, context,
          "com.aimluck.eip.lunchorder.itemNameListKey"));
      String[] splitItemName = sessionItemName.split(",", -1);
      // 商品コメント
      String sessionItemComment = new String(ALEipUtils.getTemp(rundata,
          context, "com.aimluck.eip.lunchorder.itemCommentListKey"));
      String[] splitItemComment = sessionItemComment.split(",", -1);
      // 商品価格
      String sessionItemPrice = new String(ALEipUtils.getTemp(rundata, context,
          "com.aimluck.eip.lunchorder.itemPriceListKey"));
      String[] splitItemPrice = sessionItemPrice.split(",", -1);
      // 商品フラグ
      String sessionItemMinOrderFlag = new String(ALEipUtils.getTemp(rundata,
          context, "com.aimluck.eip.lunchorder.itemMinOrderFlagListKey"));
      String[] splitItemMinOrderFlag = sessionItemMinOrderFlag.split(",", -1);

      int listSize = splitItemName.length;
      // セッション情報をvelocityで使うpreViewListに乗せかえる処理
      for (int i = 0; i < listSize; i++) {
        String preViewItemId = splitItemId[i].trim();
        String preViewItemName = splitItemName[i].trim();
        String preViewItemComment = splitItemComment[i].trim();
        String preViewItemPrice = splitItemPrice[i].trim();
        if (preViewItemPrice.equals("")) {
          break;//プレビュー時に表示させる商品がなっかた場合、プレビュー画面からの商品項目のセッションを返さない
        }
        String preViewItemMinOrderFlag = splitItemMinOrderFlag[i].trim();
        LunchOrderPreViewResultData rd = new LunchOrderPreViewResultData();

        rd.initField();
        rd.setItemId(preViewItemId);
        rd.setItemName(preViewItemName);
        rd.setItemComment(preViewItemComment);
        rd.setItemPrice(preViewItemPrice);
        rd.setItemMinOrderFlag(preViewItemMinOrderFlag);
        preViewList.add(rd);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * @return
   * @velocittyで店舗IDメソッド
   */
  public String getStoreId() {
    return storeId;
  }

  /**
   * @return
   * @velocittyで店舗名取得メソッド
   */
  public ALStringField getStoreName() {
    return storeName;
  }

  /**
   * @return
   * @velocittyで店舗コメントメソッド
   */
  public ALStringField getStoreComment() {
    return storeComment;
  }

  /**
   * @return
   * @velocityでPreViewList取得メソッド
   */
  public ArrayList<Object> getPreViewList() {
    return preViewList;
  }

  public List<String> selectList(RunData rundata, Context context) {
    try {

      return null;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  protected Object getResultData(Object obj) {
    try {
      return null;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  public Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    return null;
  }

  protected Object getResultDataDetail(Object obj) {
    return null;
  }

  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }
}
