/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import java.util.ArrayList;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * お弁当注文のフォームデータを管理するクラスです。 <BR>
 * 
 */
public class LunchOrderInputFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderInputFormData.class.getName());
  
  /**配列初期化用変数*/
  private int fieldSize;
  
  /** 商品注文数 */
  private ALNumberField[] orderSum = new ALNumberField[fieldSize];
  
  /** 注文商品のID（hiddenパラメータ） */
  private ALNumberField[] itemId = new ALNumberField[fieldSize];

  /** セッション用リスト */
  private ArrayList<Object> sessionList;

  

  /**
   * init
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField(RunData rundata) {

    fieldSize = getOrderFieldSize(rundata);// フィールドの数を取得
    orderSum = new ALNumberField[fieldSize];
    itemId = new ALNumberField[fieldSize];
    for (int i = 0; i < fieldSize; i++) {// フィールドの数分初期化
    
      orderSum[i] = new ALNumberField();// 注文数を入力するフィールド初期化
      orderSum[i].setNotNull(true);// NotNull制約を付け加える
      orderSum[i].setFieldName("注文数:" + (i + 1) + "行目");// フィールド名（エラーメッセージ表示時）
      orderSum[i].limitMaxValue(100);//注文数のMAX値設定
      orderSum[i].limitMinValue(0);//注文数のMIN値設定
      itemId[i] = new ALNumberField();// hiddenパラメータセット用フィールド
    }
  }

  /**
   * セッションにデータを設定します。
   * 
   * @param rundata
   * @param context
   * @param msgList
   *            エラーメッセージのリスト
   * @return TRUE 成功 FALSE 失敗
   */
  
  public boolean setFormData(RunData rundata, Context context, ArrayList msgList)
      throws ALPageNotFoundException, ALDBErrorException {
    boolean res = super.setFormData(rundata, context, msgList);
    if (res) {
      try {

        String itemIds[] = rundata.getParameters().getStrings("itemid[]");// 配列型で取得
        String orderSums[] = rundata.getParameters().getStrings("ordersum[]");// 配列型で取得

        sessionList = new ArrayList<Object>();// session用のリスト
        int length = getOrderFieldSize(rundata);// 配列の中身を取得し、セットしていく
        for (int i = 0; i < length; i++) {

          String item_Id = itemIds[i];
          String order_Sum = orderSums[i];

          itemId[i].setValue(item_Id);
          orderSum[i].setValue(order_Sum);

          sessionList.add(order_Sum);

        }
        String OrderSumList = sessionList.toString();
        /** セッション保存時に使用するKey名 */
        String lunchOrderSumKey = "com.aimluck.eip.lunchorder.orderSumKey";
        ALEipUtils.setTemp(rundata, context, lunchOrderSumKey, OrderSumList);// セッションに入力された情報を格納
      } catch (Exception ex) {
        logger.error("Exception", ex);
      }

    }
    return res;
  }

  /**
   * 弁当注文のフォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  public boolean validate(ArrayList msgList, RunData rundata) {
    try {

      int length = getOrderFieldSize(rundata);
      for (int i = 0; i < length; i++) {
        orderSum[i].validate(msgList);
      }

    } catch (Exception e) {
      logger.error("Exception", e);
    }
    return (msgList.size() == 0);
  }

  /**
   * エラーメッセージを設定します。
   * 
   * @param rundata
   * @param context
   * @param msgList
   *            エラーメッセージのリスト
   * @return TRUE 成功 FALSE 失敗
   */
  public boolean doCheack(ALAction action, RunData rundata, Context context) {
    try {
      init(action, rundata, context);
      ArrayList<String> msgList = new ArrayList<String>();
      boolean res = (setFormData(rundata, context, msgList) && validate(
          msgList, rundata));
      action.setResultData(this);
      action.addErrorMessages(msgList);
      action.putData(rundata, context);
      return res;
    } catch (ALPageNotFoundException e) {
      ALEipUtils.redirectPageNotFound(rundata);
      return false;
    } catch (ALDBErrorException e) {
      ALEipUtils.redirectDBError(rundata);
      return false;
    }
  }

  /**
   * 注文表にあるフィールドの数を取得するメソッド
   * 
   * @param rundata
   * @return
   */
  public int getOrderFieldSize(RunData rundata) {
    String orderFieldSizes[] = (rundata.getParameters()
        .getStrings("orderSum[]"));
    int orderFieldSize = orderFieldSizes.length;
    return orderFieldSize;
  }

  protected boolean loadFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  protected boolean deleteFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  protected boolean insertFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  protected boolean updateFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  public void initField() {
  }

  public boolean validate(ArrayList msgList) {
    return (msgList.size() == 0);
  }

  public void setValidator() {
  }

}
