/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.enquete;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.enquete.EnqueteListSelectData;
import com.aimluck.eip.enquete.EnqueteSelectData;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;


/**
 * Enqueteのアクションクラスです。 <BR>
 * 
 */
public class EnqueteAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(EnqueteAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報のクリア
    clearEnqueteSession(rundata, context);

    EnqueteSelectData listData = new EnqueteSelectData();
    listData.initField();
    //ページング
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p1a-rows")));
    listData.setStrLength(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p4a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "enquete");

  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {

      if (getMode() == null) {
        doEnquete_list_list(rundata, context);
      }

    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * Enqueteを最大化表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doEnquete_list_list(RunData rundata, Context context) throws Exception {
   
    EnqueteListSelectData listData = new EnqueteListSelectData();
    listData.initField();
    //ページング
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p4b-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "enquete-list");
  }

  private void clearEnqueteSession(RunData rundata, Context context) {
    List list = new ArrayList();
    // エンティティIDの初期化
    list.add("entityid");
    // 選択しているタブ情報の削除
    list.add("tab");
    list.add("publictab");
    list.add("target_user_id");
    list.add("target_group_name");
    list.add("com.aimluck.eip.enquete.EnqueteSelectDatafilter");
    list.add("com.aimluck.eip.enquete.EnqueteSelectDatafiltertype");
    list.add("com.aimluck.eip.enquete.EnquetePublicSelectDatasort");
    list.add("com.aimluck.eip.enquete.EnquetePublicSelectDatasorttype");
    ALEipUtils.removeTemp(rundata, context, list);
  }

}
