/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.util;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.jetspeed.test.HeadlessBaseTest;
import org.apache.jetspeed.util.parser.ValidationParameterParser;

/**
 * Command Line Test ValidationParameterParser routines.
 *
 * @author <a href="mailto:ben.woodward@bbc.co.uk">Ben Woodward</a>
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestValidationParameterParser.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestValidationParameterParser extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestValidationParameterParser( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestValidationParameterParser.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing ValidationParameterParser");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestValidationParameterParser.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testGood() throws Exception
    {
        try
        {
            Dummy dummy = new Dummy();
            ValidationParameterParser parser = new ValidationParameterParser();
            parser.add("Name", "David");
            parser.add("Age", "41");
            parser.add("Email", "david@bluesunrise.com");           
            parser.setProperties(dummy);
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    public void testFail() throws Exception
    {
        boolean failed = false;
        try
        {
            Dummy dummy = new Dummy();
            ValidationParameterParser parser = new ValidationParameterParser();
            parser.add("Name", "David");
            parser.add("Age", "1041");
            parser.add("Email", "david@bluesunrise.com");           
            parser.setProperties(dummy);
        }
        catch (Throwable t)
        {
            failed = true;
        }
        assertTrue(failed == true);
    }

    public class Dummy
    {
        private String name;
        private String email;
        private int age;
 
        public String getName()
        {
            return name;
        }

        public String getEmail()
        {
            return email;
        }

        public int getAge()
        {
            return age;
        }

        public void setName(String name)
        {
            this.name = name;
        }

        public void setEmail(String email)
        {
            this.email = email;
        }

        public void setAge(int age)
        {
            this.age = age;
        }

        public boolean validateAge(int age)
        {
            if (age > 0 && age < 120)
            {
                return true;
            }
            return false;
        }            

        public boolean validateEmail(String email)
        {
            return ValidationHelper.isEmailAddress(email, false);
        }            

        public boolean validateName(String name)
        {
            return ValidationHelper.isLooseAlphaNumeric(name, false);
        }            

        public String validate()
        {
            if (name.equals("David"))
            {
                if (email.equals("david@bluesunrise.com"))
                {
                    return null;
                }
                else
                {
                    return "Bad Email/Name combination";                    
                }
            }
            else
            {
                return "Bad Name/Email combination";
            }
        }
    }
        
}
