/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.util;

// Junit imports
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;

// Cactus imports
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;

// Jetspeed imports
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.test.TurbineTestUtilities;

// Turbine imports
//import org.apache.turbine.om.security.User;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;

// Velocity
import org.apache.velocity.context.Context;

/**
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: TestMimeType.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestMimeType extends ServletTestCase
{
    private static final String TEST_ANON_USER_NAME = "";
    private static final String TEST_CONTEXT = null;
    private static final String TEST_DEFAULT_PAGE = "default";
    private static final String TEST_HOST = "localhost";
    private static final String TEST_SERVLET = "/portal";
    private static final String TEST_GROUP = "apache";
    private static final String TEST_PAGE = "news";
    private static final String TEST_USER = "turbine";
    private static final String TEST_USER_PASSWORD = "turbine";
    
    private RunData rundata = null;

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestMimeType(String name)
    {
        super(name);
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        TestRunner.main(new String[] { TestMimeType.class.getName() });
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestMimeType.class);
    }
    
    /**
     * Sets up the test case.
     *
     */
    protected void setUp () throws Exception 
    {
    }
    
    /**
     *  Test: DefaultURL
     *  With the default URL "/"
     *    1) A page is generated 
     *    2) The user is anonymous
     *    3) Group and Role are not set
     */
    public void beginDefaultURL(WebRequest theRequest)
    {
        System.out.println("URL = " + theRequest.getURL());
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET, "", null); 
        System.out.println("post set URL = " + theRequest.getURL());
    }

    /**
     * Execute the test
     *
     * @throws Exception
     */
    public void testDefaultURL() throws Exception
    {
        // Create the RunData object to be used during testing.        
        rundata = RunDataFactory.getRunData(request, response, config);
        assertNotNull("Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);

        // Verify we have a CapabilityMap
        CapabilityMap cm = ((JetspeedRunData) rundata).getCapability();
        assertNotNull("Got Capability", cm);

        // Verify we have a profile
        Profile profile = Profiler.getProfile(rundata);
        assertNotNull("Got profile from Profiler", profile);
        System.out.println("DocumentName = " + profile.getDocument().getName()); 

        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull("Got context", context);
        TurbinePull.populateContext(context, rundata);

        // Verify tool are in the context
        assertNotNull("Got jlink from context", context.get("jlink"));

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        assertEquals("Verifying page's character set",
            rundata.getCharSet(), 
            JetspeedResources.getString(JetspeedResources.CONTENT_ENCODING_KEY, "utf-8"));

        TurbineTestUtilities.outputPage(rundata);

        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }

    public void endDefaultURL(WebResponse theResponse)
    {
        System.out.println("text length = " + theResponse.getText().length());
    }
}
