/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.util.rewriter;

import java.io.Reader;
import java.io.InputStreamReader;

import java.net.URL;
import java.net.URLConnection;

public class TestRewriter // extends TestCase 
{
    /*
    static public Test suite()
    {
        TestSuite suite = new TestSuite(TestRewriter.class);
        return(suite);
    }
      */
    public TestRewriter(String name)
    {
        //super(name);
    }

    ///////////////////////////////////////////////////////////////////////////
            

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }


    ///////////////////////////////////////////////////////////////////////////

    public void testPage()
    {
        Reader reader = null;

        try 
        {
            String baseURL = "http://java.sun.com/";
            String fullURL = "http://java.sun.com/";

            //URL pageUrl = new URL("http://www.devx.com/Java/Article/9747/");
            URL pageUrl = new URL(fullURL);

            URLConnection  pageConn = pageUrl.openConnection();
            String         encoding = pageConn.getContentEncoding();

            if(encoding == null)
            {
                // Standard HTTP encoding
                encoding = "iso-8859-1";
            }

            reader = new InputStreamReader(pageConn.getInputStream(),
                                               encoding );
            
            //String crap = Streams.getAsString(reader);
            //System.out.println("crap = " + crap);
            
            HTMLRewriter rewriter = new HTMLRewriter();

            // String result = rewriter.rewrite(reader, "XXXX", "YYYY");
            String result = rewriter.rewrite(reader, baseURL);
            System.out.println(result);
            
            reader.close();
            reader = null;

        } catch (Exception e) 
        {
            System.err.println("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        finally
        {
            try
            {
                if (null != reader)
                    reader.close();
            }
            catch (Exception e)
            {}
        }
    }

    ///////////////////////////////////////////////////////////////////////////

    static public void main(String[] argv)
    {
        // String[] testCaseName = {TestRewriter.class.getName()};
        // junit.swingui.TestRunner.main(testCaseName);
        TestRewriter trw = new TestRewriter("test");
        trw.testPage();

    }

}

