require 'test/unit/assertions'
require 'umigame/arrayoptparser'

module Umigame
  class Adder
    include Test::Unit::Assertions
    
    attr_reader :code
    
    def initialize(comment, code)
      @code = code
      @comment = comment
      @parser = ArrayOptParser.new
      @parser.set_option(
      ['--add', 'a', ArrayOptParser::REQUIRED_ARGUMENT],
      ['--include', 'i', ArrayOptParser::REQUIRED_ARG_MULTI]
      )
    end
    
    def output
      return {@parser['add']=>@code.print}
    end
    
    def set_argv(argv)
      @parser.parse(argv)
      file = open(@parser['add'])
      parse(file.readlines)
      @parser['include'].each do |file|
        @code.add_include file
      end
      @parser.other.each do |methodname|
        @code.add_new_method methodname
      end
    end
    
    def parse(source)
      @source = source
      @code.line = @source.size
      parse_include
      parse_class_begin
      parse_method
      skip_space
      parse_suite
      parse_class_end
    end
    
    protected
    
    def skip_space
      until @source.first =~ /\S/ or @source == []
        @source.shift
      end
    end
    
    def do_parse_include(include_regex)
      parse_tag("include") do |line|
        line =~ include_regex
        @code.add_include $1
      end
    end
    
    def do_parse_class_begin(class_begin_regex)
      line = @source.shift
      until line =~ /#{@comment}CUPPA:decl=+/
        if @source.first =~ class_begin_regex
          @code.class_name = $1
        end
        @code.class_begin.push line
        line = @source.shift
      end
    end
    
    def parse_class_end
      @source.each do |line|
        @code.class_end.push line
      end
    end
    
    def do_parse_method(method_regex)
      unless @source.shift =~ method_regex
        flunk("parse error in test method in #{@code.line - @source.size}")
      end
      method_name = $2
      comment_out = ($1 == @comment)
      line = @source.shift
      code = ""
      until line == "#{@comment}CUPPA:decl=-\n"
        if line =~ method_regex
          @code.add_method method_name, comment_out, code
          code = ""
          comment_out = ($1 == @comment)
          method_name = $2
        else
          code += line[2..-1] if 2 < line.size
        end
        line = @source.shift
      end
      @code.add_method method_name, comment_out, code
    end
    
    def do_parse_suite(suite_begin_regex, suite_regex, start_count = 0, end_count = 2)
      start_count.times do
        @source.shift
      end
      if @source.first =~ suite_begin_regex
        @code.has_suite = true
        parse_tag("suite") do |line|
          if line =~ suite_regex
            method = @code.get_method($2)
            assert_not_nil(method, "method name error in #{@code.line - @source.size}")
            method.comment_out = true if $1 == @comment
          end
        end
        end_count.times do |n|
          @source.shift
        end
      else
        @code.has_suite = false
      end
    end
    
    def parse_tag(tag)
      until @source.first == "#{@comment}CUPPA:#{tag}=+\n"
        assert_not_nil(@source.shift, "tag:<#{tag}> not found")
      end
      @source.shift
      until @source.first == "#{@comment}CUPPA:#{tag}=-\n"
        line = @source.shift
        assert_not_nil(line, "tag:#{tag} not found")
        yield line
      end
      @source.shift
    end
  end
end
