#include "TestDB.h"
#include "micuni.h"

void micuni_puts(const char* s) {
  while ( *s ) micuni_putchar(*s++);
}

int micuni_strlen(const char* s) {
  int len;   
  for ( len = 0; *s; ++s )
    ++len;
  return len;
}

char* micuni_strcpy(char* dst, const char* src) {
  while ( (*dst++ = *src++) != 0 ) 
    ;
  return --dst;
}

const char* micuni_ltoa(long n) {
  static char buffer[16];
  int s, t, neg;
  s = 0; neg = 0;
  if ( n == 0 ) return "0";
  if ( n < 0 ) {
    n = -n;
    neg = 1;
  }
  while ( n != 0 ) {
    buffer[s++] = (char)(n % 10L + '0');
    n = n / 10;
  }
  if ( neg ) {
    buffer[s++] = '-';
  }
  buffer[s--] = '\0';
  for ( t = 0; t < s; ++t ) {
    char c = buffer[t];
    buffer[t] = buffer[s];
    buffer[s] = c;
    --s;
  }
  return buffer;
}

char micuni_toupper(char c) {
  if ( c >= 'a' && c <= 'z' ) 
    return (char)(c - 'a' + 'A');
  return c;
}

int micuni_isspace(int c) {
  int result = 0;
  switch ( c ) {
  case ' ' : 
  case '\t' : 
  case '\n' :
    result = 1;
  }
  return result;
}

void micuni_putresult(void) {
  int runs;
  int failures;
  int groups;
  TestResult* result;

  runs     = get_registry()->uiNumberOfTests;
  failures = get_registry()->uiNumberOfFailures;
  groups   = get_registry()->uiNumberOfGroups;
  result   = get_registry()->pResult;

  micuni_puts("groups:   "); micuni_puts(micuni_ltoa(groups));   micuni_putln();
  micuni_puts("runs:     "); micuni_puts(micuni_ltoa(runs));     micuni_putln();
  micuni_puts("failures: "); micuni_puts(micuni_ltoa(failures)); micuni_putln();
  micuni_putln();
  while ( result ) {
    micuni_puts(result->strFileName);
    if ( result->uiLineNumber ) {
      micuni_puts(" ("); micuni_puts(micuni_ltoa(result->uiLineNumber)); micuni_putchar(')');
    }
    micuni_putchar(' ');micuni_puts(result->pTestGroup->pName); 
    if ( result->pTestCase ) {
      micuni_puts("."); micuni_puts(result->pTestCase->pName);
    }
    micuni_putln();
    micuni_puts(result->strCondition); micuni_putln(); micuni_putln();
    result = result->pNext;
  }  
}

int micuni_strcmp(const char* szSrc, const char* szDest) {
  while (*szSrc && *szDest ) {
    szSrc++;
    szDest++;
  }
  return *szSrc - *szDest;
}
