/*
 * 'cuppa' : CppUnit Post Process Aid $Revision: 1.7 $
 *    by Ã΃ǃЃуŃʃ
 *
 * # 'cuppa' means 'a cup of tea' or '͓' :-)
 *
 * [requirements]
 *   Boost Regex++   http://www.boost.org/
 *   CppUnit 1.6.2+  http://sourceforge.net/projects/cppunit/
 *
 * [special thanks to]
 *   MORINO, Shin'ya : Linux port
 *   Ђ          : BC++  port
 */

#include <cstdio>   // POPEN/PCLOSE
#include <iostream> // cerr/cout/endl
#include <fstream>  // ofstream
#include <string>   // string
#include <set>      // set
#include <map>      // map

#include <boost/regex.hpp> // Boost Regex++

#include <sys/types.h>
#include <sys/stat.h>

/*
 * config.
 */
#include "config.h"

#ifdef NO_GETOPT
#ifndef __STDC__
#  define __STDC__ 1
#  include "getopt.h" // getopt_long
#  undef __STDC__
#else
#  include "getopt.h" // getopt_long
#endif
#else
#include <getopt.h>
#endif

/*
 * t@C֘A
 */
#define SUITE_TRAIL "_suite" // TestSuite̖ɒǉ

/*
 * O
 */
using namespace std;
using namespace boost;

/*
 * Ղł
 */
typedef set<string>            cases_type;
typedef map<string,cases_type> suites_type;

/*
 * ւ
 */
void usage() {
  cout << "--help, -h            : display help\n"
          "--version, -v         : print version\n"
          "--main, -m <file>     : create 'file' that implements main()\n"
          "--skeleton, -s <Name> : create skeleton Name.h and Name.cpp\n";
}

/*
 * ΁[
 */
void version() {
  cout << "cuppa $Revision: 1.7 $" << endl;
}

/*
 * ̃t@Cɑ΂ true Ԃ
 */
bool exist(const string& path) {
  ifstream stream(path.c_str());
  return stream.is_open();
}

/*
 * suite 
 */
void make_suite(const string& path, const string& suite, cases_type& cases) {
    cerr << path << " ... ";
    ofstream strm(path.c_str());
    if ( strm.is_open() ) {
      cerr << "create.\n";
      strm << "#include \"" << suite << DECL_SUFFIX "\"\n\n"
              "#include <cppunit/extensions/HelperMacros.h>\n\n"
              "CppUnit::Test* " << suite << "::suite() {\n"
              "  typedef CppUnit::TestCaller<" << suite << "> caller;\n"
              "  CppUnit::TestSuite* suite = new CppUnit::TestSuite(\"" << suite << "\");\n";
      for ( cases_type::iterator citer = cases.begin(); citer != cases.end(); ++citer ) {
        strm << "  suite->addTest(new caller(\"" << *citer << "\", &" << suite << "::" << *citer << "));\n";
      }
      strm << "  return suite;\n"
              "}\n\n"
              "CPPUNIT_TEST_SUITE_REGISTRATION(" << suite << ");\n";
    }
}

/*
 * TestCase ̐`
 */
void make_skeleton(const string& basename) {
  string path = basename + DECL_SUFFIX;;
  cerr << path << " ... ";
  if ( exist(path) ) {
    cerr << "already exists. (skip)\n";
  } else {
    ofstream strm(path.c_str());
    if ( strm.is_open() ) {
    cerr << " create.\n";
    strm << "#ifndef " << basename << "_h\n"
            "#define " << basename << "_h\n\n"
            "#include <cppunit/TestCase.h>\n"
            "class " << basename << " : public CppUnit::TestCase {\n"
            "public:\n"
            "  void test_XXX();\n\n"
            "  // do NOT edit following!\n"
            "  static CppUnit::Test* suite();\n" 
            "};\n\n"
            "#endif\n";
    }
  }
  path = basename + IMPL_SUFFIX;
  cerr << path << " ... ";
  if ( exist(path) ) {
    cerr << "already exists. (skip)\n";
  } else {
    ofstream strm(path.c_str());
    if ( strm.is_open() ) {
      cerr << " create.\n";
      strm << "#include \"" << basename << ".h\"\n\n"
              "#include <cppunit/TestAssert.h>\n\n"
              "/** @test description of test_XXX */\n"
              "void " << basename << "::test_XXX() { \n"
              "  CPPUNIT_ASSERT_MESSAGE(\"no implementation\",false);\n"
              "}\n\n";
    }
  }

  path = basename + SUITE_TRAIL IMPL_SUFFIX;
  if ( exist(path) ) {
    cerr << "already exists. (skip)\n";
  } else {
    cases_type tmp;
    tmp.insert("test_XXX");
    make_suite(path, basename, tmp);
  }

}

/*
 * main 
 */
void make_main(const string& basename) {
  string path = basename + IMPL_SUFFIX;
  cerr << path << " ... ";
  if ( exist(path) ) {
    cerr << "already exists. skip.\n";
  } else {
    ofstream strm(path.c_str());
    if ( strm.is_open() ) {
      cerr << " create.\n";
      strm << "#include <iostream>\n" \
              "#include <string>\n"
              "#include <cppunit/TextTestResult.h>\n" \
              "#include <cppunit/Test.h>\n"
#ifdef USE_CLEVER_CPPUNIT
              "#include <cppunit/XmlOutputter.h>\n"
              "#include <cppunit/TextOutputter.h>\n"
              "#include <cppunit/CompilerOutputter.h>\n"
#endif
              "#include <cppunit/extensions/TestFactoryRegistry.h>\n\n"
              "int main(int argc, char* argv[]) {\n"
              "  int format = 0;\n"
              "  int target = 0;\n"
              "  for ( int i = 1; i < argc; ++i ) {\n"
              "    std::string arg(argv[i]);\n"
              "    if ( arg == \"--text\"     ) format = 0;\n"
#ifdef USE_CLEVER_CPPUNIT
              "    if ( arg == \"--xml\"      ) format = 1;\n"
              "    if ( arg == \"--compiler\" ) format = 2;\n"
#endif
              "    if ( arg == \"--cerr\"     ) target = 1;\n"
              " }\n"
              " CppUnit::TextTestResult result;\n"
              " CppUnit::TestFactoryRegistry::getRegistry().makeTest()->run(&result);\n"
#ifdef USE_CLEVER_CPPUNIT
              "  CppUnit::Outputter* outputter = 0;\n"
              "  std::ostream* stream = target ? &std::cerr : &std::cout;\n"
              "  switch ( format ) {\n"
              "  case 0 : outputter = new CppUnit::TextOutputter(&result,*stream); break;\n"
              "  case 1 : outputter = new CppUnit::XmlOutputter(&result,*stream, \"" XML_ENCODING "\"); break;\n"
              "  case 2 : outputter = new CppUnit::CompilerOutputter(&result,*stream); break;\n"
              "  }\n"
              "  outputter->write();\n"
              "  delete outputter;\n"
#else
              "  result.print(target ? std::cerr : std::cout);\n"
#endif
              "  return result.wasSuccessful() ? 0 : 1;\n"
              "}\n";
    }
  }
}

/*
 * cuppa atarts here!!
 */
int main(int argc, char* argv[]) {

  string gen_main;
  string path;

  // R}hC
  while ( true ) {
    int this_option_optind = optind ? optind : 1;
    int option_index = 0;
    static struct option long_options[] = {
      { "help",     0, 0, 'h'},
      { "main",     1, 0, 'm'},
      { "skeleton", 1, 0, 's'},
      { "version",  0, 0, 'v'},
      { 0, 0, 0, 0 }
    };

    int c = getopt_long(argc, argv, "hm:s:v", long_options, &option_index);
    if ( c == -1 ) break;

    switch ( c ) {
    case 'm' : 
      gen_main = optarg; 
      break;

    case 's' :
      make_skeleton(optarg);
      break;

    case 'v' :
      version();
      return 0;

    case 'h' :
      usage();
      return 0;
    }
  }

  suites_type suites;
  reg_expression<char>       regex(PATTERN);
  match_results<const char*> results;

  // suite() 
  while ( optind < argc ) {
    string command = EXTRACT_PRE;
    command += argv[optind++];
    command += EXTRACT_POST;
    cerr << command << flush;
    // .obj  XXX::test???() 
    FILE* fp = POPEN( command.c_str(), "r");
    if ( !fp ) {
      cerr << "  ... FAIL" << endl;
      continue;
    }
    cerr << "  ... ok" << endl;
    static char buffer[4096]; // ܁Â炢΂B
    while ( fgets(buffer,4096,fp) ) {
      if ( regex_search(buffer, results, regex) ) {
        suites[results.str(1)].insert(results.str(2));
      }
    }
    PCLOSE(fp);
  }

  for ( suites_type::iterator siter = suites.begin(); siter != suites.end(); ++siter ) {
    cases_type& cases = siter->second;
    path = siter->first + SUITE_TRAIL IMPL_SUFFIX;
    // XXX_suite.cpp@ XXX::test??? AXV̗v/sv𔻒肷
    cases_type current;
    ifstream strm(path.c_str());
    string line;
    if ( strm.is_open() ) {
      regex = "&" + siter->first + "::(test[^)]*)";
      while ( getline(strm, line) ) {
        if ( regex_search(line.c_str(), results, regex) ) {
          current.insert(results.str(1));
        }
      }
      // XVsv!
      if ( cases == current ) {
        continue;
      }
    }
    make_suite(path, siter->first, cases);
  }
 
  if ( !gen_main.empty() ) {
    make_main(gen_main);
  }

  return 0;
}
