CPPUNIT_ROOT   = d:\cppunit-1.7.10
CPPUNIT_INCDIR = $(CPPUNIT_ROOT)\include
CPPUNIT_LIBDIR = $(CPPUNIT_ROOT)\lib
CPPUNIT_LIB    = cppunit.lib

CUPPA = ..\cuppa.exe

CPPFLAGS = -GX -MD -I$(CPPUNIT_INCDIR)

TESTER_OBJS = FooTest.obj FooTest_suite.obj BarTest.obj BarTest_suite.obj

TARGET = run.exe
OBJS = run.obj $(TESTER_OBJS)

$(TARGET) : $(OBJS)
        $(CPP) -Fe$(TARGET) $(OBJS) $(CPPUNIT_LIB) -link -libpath:$(CPPUNIT_LIBDIR)

BarTest_suite.cpp : BarTest.obj
        $(CUPPA) BarTest.obj

FooTest_suite.cpp : FooTest.obj
        $(CUPPA) FooTest.obj

initial: clean
        $(CUPPA) --main run
        $(CUPPA) --skeleton FooTest
        $(CUPPA) --skeleton BarTest

clean:
        -del *.obj
        -del *.cpp
        -del *.h

