/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: EmptyFilterTest.java,v 1.0 2005/12/21 12:59:04 Teletha Exp $
 */
public class EmptyFilterTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.filter.EmptyFilter.accept(Element)'
     */
    public void testAccept1() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("empty");
        Filter filter = EmptyFilter.SINGLETON;

        // empty element
        assertEquals(true, filter.accept(element));

        // zero length text
        element.appendChild(document.createTextNode(""));
        assertEquals(true, filter.accept(element));

        // non-zero length text
        element.appendChild(document.createTextNode("text"));
        assertEquals(false, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.EmptyFilter.accept(Element)'
     */
    public void testAccept2() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("empty");
        Filter filter = EmptyFilter.SINGLETON;

        // empty element
        assertEquals(true, filter.accept(element));

        // child element
        Element child = document.createElement("child");
        element.appendChild(child);
        assertEquals(false, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.EmptyFilter.accept(Element)'
     */
    public void testAccept3() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("empty");
        Filter filter = EmptyFilter.SINGLETON;

        // empty element
        assertEquals(true, filter.accept(element));

        // child comment
        element.appendChild(document.createComment("comment"));
        assertEquals(true, filter.accept(element));

        // child PI
        element.appendChild(document.createProcessingInstruction("test", "PI"));
        assertEquals(true, filter.accept(element));

        // text child
        element.appendChild(document.createTextNode("text"));
        assertEquals(false, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.EmptyFilter.accept(Element)'
     */
    public void testAccept4() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("empty");
        Filter filter = EmptyFilter.SINGLETON;

        // empty element
        assertEquals(true, filter.accept(element));

        // white space
        element.appendChild(document.createTextNode(" "));
        assertEquals(false, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.EmptyFilter.accept(Element)'
     */
    public void testAccept5() throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElement("empty");
        Filter filter = EmptyFilter.SINGLETON;

        // empty element
        assertEquals(true, filter.accept(element));

        // zoro length CDATA
        element.appendChild(document.createCDATASection(""));
        assertEquals(true, filter.accept(element));

        // non-zero length CDATA
        element.appendChild(document.createCDATASection("cdata"));
        assertEquals(false, filter.accept(element));
    }
}
