/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.w3c.dom.Document;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ElementFilterTest.java,v 1.0 2005/12/21 19:55:18 Teletha Exp $
 */
public class ElementFilterTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.filter.ElementFilter.accept(Element)'
     */
    public void testNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new ElementFilter(null, "uri", "name");

        // element without namespace
        assertEquals(false, filter.accept(document.createElement("name")));

        // element with namespace
        assertEquals(false, filter.accept(document.createElementNS("", "name")));
        assertEquals(true, filter.accept(document.createElementNS("uri", "name")));
    }

    /*
     * Test method for 'org.trix.cuery.filter.ElementFilter.accept(Element)'
     */
    public void testUniversalNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new ElementFilter(null, null, "name");

        // element without namespace
        assertEquals(true, filter.accept(document.createElement("name")));

        // element with namespace
        assertEquals(true, filter.accept(document.createElementNS("one", "name")));
        assertEquals(true, filter.accept(document.createElementNS("two", "name")));

        // no matche
        assertEquals(false, filter.accept(document.createElement("invalid")));
        assertEquals(false, filter.accept(document.createElementNS("", "invalid")));
        assertEquals(false, filter.accept(document.createElementNS("test", "invalid")));
    }

    /*
     * Test method for 'org.trix.cuery.filter.ElementFilter.accept(Element)'
     */
    public void testNamespaceAndUniversalName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new ElementFilter(null, "uri", "*");

        // element without namespace
        assertEquals(false, filter.accept(document.createElement("name")));

        // element with namespace
        assertEquals(false, filter.accept(document.createElementNS("", "name")));
        assertEquals(false, filter.accept(document.createElementNS("invalid", "name")));

        assertEquals(true, filter.accept(document.createElementNS("uri", "name")));
    }

    /*
     * Test method for 'org.trix.cuery.filter.ElementFilter.accept(Element)'
     */
    public void testUniversalNamespaceAndUniversalName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new ElementFilter(null, null, "*");

        // element without namespace
        assertEquals(true, filter.accept(document.createElement("name")));

        // element with namespace
        assertEquals(true, filter.accept(document.createElementNS("", "name")));
        assertEquals(true, filter.accept(document.createElementNS("uri", "name")));
    }
    
    /*
     * Test method for 'org.trix.cuery.filter.ElementFilter.accept(Element)'
     */
    public void testUndeclaredNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new ElementFilter(null, "", "name");

        // element without namespace
        assertEquals(true, filter.accept(document.createElement("name")));

        // element with namespace
        assertEquals(true, filter.accept(document.createElementNS("", "name")));
        assertEquals(false, filter.accept(document.createElementNS("", "invalid")));
        assertEquals(false, filter.accept(document.createElementNS("uri", "name")));
    }
}
