/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AttributeFilterTest.java,v 1.0 2005/12/21 20:08:16 Teletha Exp $
 */
public class AttributeFilterTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.filter.AttributeFilter.accept(Element)'
     */
    public void testNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new AttributeFilter(null, "uri", "name", "value");

        // create element
        Element element = document.createElement("test");
        element.setAttribute("invalid", "value");
        assertEquals(false, filter.accept(element));

        // append attribute
        element.setAttribute("name", "value");
        assertEquals(false, filter.accept(element));

        // append attribute with namespace
        element.setAttributeNS("uri", "name", "value");
        assertEquals(true, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.AttributeFilter.accept(Element)'
     */
    public void testUniversalNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new AttributeFilter(null, null, "name", "value");

        // create element
        Element element = document.createElement("test");
        element.setAttribute("invalid", "value");
        element.setAttribute("name", "invalid");
        assertEquals(false, filter.accept(element));

        // append attribute
        element.setAttribute("name", "value");
        assertEquals(true, filter.accept(element));

        // remove attribute
        element.removeAttribute("name");
        assertEquals(false, filter.accept(element));

        // append attribute with namespace
        element.setAttributeNS("uri", "name", "value");
        assertEquals(true, filter.accept(element));
    }

    /*
     * Test method for 'org.trix.cuery.filter.AttributeFilter.accept(Element)'
     */
    public void testUndeclaredNamespaceAndName() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);

        Document document = factory.newDocumentBuilder().newDocument();
        Filter filter = new AttributeFilter(null, "", "name", "value");

        // create element
        Element element = document.createElement("test");
        element.setAttribute("invalid", "value");
        assertEquals(false, filter.accept(element));

        // append attribute with namespace
        element.setAttributeNS("uri", "name", "value");
        assertEquals(false, filter.accept(element));

        // append attribute without namespace
        element.setAttributeNS(null, "name", "value");
        assertEquals(true, filter.accept(element));
    }
}
