/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import junit.framework.TestCase;

import org.trix.cuery.property.Property;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: StyleListenerTest.java,v 1.0 2005/12/11 12:30:35 Teletha Exp $
 */
public class StyleListenerTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.StyleListener.styleChanged(Property)'
     */
    public void testStyleChanged1() throws Exception {
        CSSWeaver weaver = new CSSWeaver();
        weaver.awareDOMMutation(true);
        weaver.addAuthorStylesheet(CSSUtil.getSource("src/test/resource/listener/test001.css"));

        // apply style
        Document document = weaver.apply("src/test/resource/listener/test001.xml");

        Element target = DOMUtil.getElementById(document, "target");
        Property property = StyleContext.getProperty(target);
        assertEquals("block", property.getValueAsString("display"));

        // register listener
        StyleContext context = StyleContext.getContext(target);
        ChangeListener listener = new ChangeListener();
        context.addListener(listener);

        // change state
        context.assign(CSS.HOVER);

        // listen event
        assertNotNull(listener.property);
        assertEquals("inline", property.getValueAsString("display"));
        assertEquals("inline", listener.property.getValueAsString("display"));
    }

    /**
     * DOCUMENT.
     * 
     * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
     * @version $ Id: ChangeListener.java,v 1.0 2005/12/11 12:39:06 Teletha Exp $
     */
    private static final class ChangeListener implements StyleListener {

        private Property property;

        /**
         * @see org.trix.cuery.StyleListener#styleChanged(org.trix.cuery.property.Property)
         */
        public void styleChanged(Property property) {
            this.property = property;
        }
    }
}
