/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: StyleContextTest.java,v 1.0 2005/12/08 10:24:17 Teletha Exp $
 */
public class StyleContextTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.CSS.hasState(int)'
     */
    public void testHasState() {
        StyleContext context = new StyleContext(null);
        assertEquals(false, context.hasState(CSS.ACTIVE));
        assertEquals(false, context.hasState(CSS.CHECKED));
        assertEquals(false, context.hasState(CSS.DEFAULT));
        assertEquals(false, context.hasState(CSS.DISABLED));
        assertEquals(false, context.hasState(CSS.ENABLED));
        assertEquals(false, context.hasState(CSS.FOCUS));
        assertEquals(false, context.hasState(CSS.HOVER));
        assertEquals(false, context.hasState(CSS.IN_RANGE));
        assertEquals(false, context.hasState(CSS.INVALID));
        assertEquals(false, context.hasState(CSS.LINK));
        assertEquals(true, context.hasState(CSS.NORMAL));
        assertEquals(false, context.hasState(CSS.OPTIONAL));
        assertEquals(false, context.hasState(CSS.OUT_OF_RANGE));
        assertEquals(false, context.hasState(CSS.READ_ONLY));
        assertEquals(false, context.hasState(CSS.READ_WRITE));
        assertEquals(false, context.hasState(CSS.REQUIRED));
        assertEquals(false, context.hasState(CSS.TARGET));
        assertEquals(false, context.hasState(CSS.VALID));
        assertEquals(false, context.hasState(CSS.VISITED));

        // double
        assertEquals(false, context.hasState(CSS.ACTIVE | CSS.CHECKED));
        assertEquals(false, context.hasState(CSS.ACTIVE | CSS.NORMAL));
    }

    /*
     * Test method for 'org.trix.cuery.property.CSS.assign(int)'
     */
    public void testAssign() {
        StyleContext context = new StyleContext(null);
        assertEquals(false, context.hasState(CSS.ACTIVE));

        // assign once
        context.assign(CSS.ACTIVE);
        assertEquals(true, context.hasState(CSS.ACTIVE));

        // assign twice (double manipulation test)
        context.assign(CSS.ACTIVE);
        assertEquals(true, context.hasState(CSS.ACTIVE));

        // second state
        context.assign(CSS.LINK);
        assertEquals(true, context.hasState(CSS.LINK));
        assertEquals(true, context.hasState(CSS.ACTIVE | CSS.LINK));

        // exclusive state
        context.assign(CSS.VISITED);
        assertEquals(true, context.hasState(CSS.VISITED));
        assertEquals(true, context.hasState(CSS.ACTIVE | CSS.VISITED));
        assertEquals(false, context.hasState(CSS.LINK));

        // double assign
        context.assign(CSS.CHECKED | CSS.DEFAULT);
        assertEquals(true, context.hasState(CSS.CHECKED));
        assertEquals(true, context.hasState(CSS.DEFAULT));

        // mate check
        context.assign(CSS.ACTIVE | CSS.ENABLED);
        assertEquals(true, context.hasState(CSS.ACTIVE));
        assertEquals(true, context.hasState(CSS.ENABLED));
    }

    /*
     * Test method for 'org.trix.cuery.property.CSS.deprive(int)'
     */
    public void testDeprive() {
        StyleContext context = new StyleContext(null);
        assertEquals(false, context.hasState(CSS.ACTIVE));

        // deprive from no state
        context.deprive(CSS.ACTIVE);
        assertEquals(false, context.hasState(CSS.ACTIVE));

        // assign and deprive
        context.assign(CSS.ACTIVE);
        assertEquals(true, context.hasState(CSS.ACTIVE));

        context.deprive(CSS.ACTIVE);
        assertEquals(false, context.hasState(CSS.ACTIVE));

        // double deprival
        context.assign(CSS.ACTIVE | CSS.CHECKED);
        assertEquals(true, context.hasState(CSS.ACTIVE | CSS.CHECKED));

        context.deprive(CSS.ACTIVE | CSS.CHECKED);
        assertEquals(false, context.hasState(CSS.ACTIVE));
        assertEquals(false, context.hasState(CSS.CHECKED));

        // mate check
        context.assign(CSS.ACTIVE);
        assertEquals(true, context.hasState(CSS.ACTIVE));

        context.deprive(CSS.ACTIVE | CSS.CHECKED);
        assertEquals(false, context.hasState(CSS.ACTIVE));
        assertEquals(false, context.hasState(CSS.CHECKED));

        // exclusive state
        context.assign(CSS.LINK);
        context.deprive(CSS.LINK);
        assertEquals(false, context.hasState(CSS.LINK));
        assertEquals(true, context.hasState(CSS.VISITED));

        context.deprive(CSS.VISITED);
        assertEquals(true, context.hasState(CSS.LINK));
        assertEquals(false, context.hasState(CSS.VISITED));
    }

    /*
     * Test method for 'org.trix.cuery.property.CSS.clearState()'
     */
    public void testClearState() {
        StyleContext context = new StyleContext(null);
        assertEquals(true, context.hasState(CSS.NORMAL));

        // clear from no state
        context.clearState();
        assertEquals(true, context.hasState(CSS.NORMAL));

        // assign and clear
        context.assign(CSS.ACTIVE);
        assertEquals(true, context.hasState(CSS.ACTIVE));

        context.clearState();
        assertEquals(true, context.hasState(CSS.NORMAL));

        // assing twice and clear
        context.assign(CSS.ACTIVE | CSS.CHECKED);
        assertEquals(true, context.hasState(CSS.ACTIVE | CSS.CHECKED));

        context.clearState();
        assertEquals(true, context.hasState(CSS.NORMAL));
    }
}
