/*
 * Copyright 2004-2006 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.util.event;

import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.UIEvent;
import org.w3c.dom.views.AbstractView;

import com.sun.org.apache.xerces.internal.dom.events.EventImpl;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: XercesUIEvent.java,v 1.0 2006/03/24 14:32:47 Teletha Exp $
 */
public class XercesUIEvent extends EventImpl implements UIEvent {

    private EventImpl actual;

    private AbstractView view;

    private int detail;

    public XercesUIEvent(Event event) {
        if (event instanceof EventImpl) {
            actual = (EventImpl) event;
        }
        super.initEvent(event.getType(), event.getBubbles(), event.getCancelable());
    }

    /**
     * @see org.w3c.dom.events.UIEvent#getDetail()
     */
    public int getDetail() {
        return detail;
    }

    /**
     * @see org.w3c.dom.events.UIEvent#getView()
     */
    public AbstractView getView() {
        return view;
    }

    /**
     * @see org.w3c.dom.events.UIEvent#initUIEvent(java.lang.String, boolean, boolean,
     *      org.w3c.dom.views.AbstractView, int)
     */
    public void initUIEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, AbstractView viewArg, int detailArg) {
        super.initEvent(typeArg, canBubbleArg, cancelableArg);

        this.view = viewArg;
        this.detail = detailArg;
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getBubbles()
     */
    public boolean getBubbles() {
        return actual.getBubbles();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getCancelable()
     */
    public boolean getCancelable() {
        return actual.getCancelable();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getCurrentTarget()
     */
    public EventTarget getCurrentTarget() {
        return currentTarget;
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getEventPhase()
     */
    public short getEventPhase() {
        return actual.getEventPhase();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getTarget()
     */
    public EventTarget getTarget() {
        return target;
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getTimeStamp()
     */
    public long getTimeStamp() {
        return actual.getTimeStamp();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#getType()
     */
    public String getType() {
        return actual.getType();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#initEvent(java.lang.String,
     *      boolean, boolean)
     */
    public void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg) {
        actual.initEvent(eventTypeArg, canBubbleArg, cancelableArg);
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#preventDefault()
     */
    public void preventDefault() {
        actual.preventDefault();
    }

    /**
     * @see com.sun.org.apache.xerces.internal.dom.events.EventImpl#stopPropagation()
     */
    public void stopPropagation() {
        actual.stopPropagation();
    }
}
