/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.sac;

import org.trix.cuery.filter.AttributeFilter;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.EmptyFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.FirstChildFilter;
import org.trix.cuery.filter.FirstTypedFilter;
import org.trix.cuery.filter.HyphenTokensFilter;
import org.trix.cuery.filter.IDFilter;
import org.trix.cuery.filter.LangFilter;
import org.trix.cuery.filter.LastChildFilter;
import org.trix.cuery.filter.LastTypedFilter;
import org.trix.cuery.filter.MultipleFilter;
import org.trix.cuery.filter.OnlyChildFilter;
import org.trix.cuery.filter.OnlyTypedFilter;
import org.trix.cuery.filter.PseudoClassFilter;
import org.trix.cuery.filter.RootFilter;
import org.trix.cuery.filter.TokensFilter;
import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.PositionalCondition;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ConditionFactoryImpl.java,v 1.02 2005/12/21 12:30:56 Teletha Exp $
 */
public class ConditionFactoryImpl implements ConditionFactory {

    /**
     * @see org.w3c.css.sac.ConditionFactory#createAndCondition(org.w3c.css.sac.Condition,
     *      org.w3c.css.sac.Condition)
     */
    public CombinatorCondition createAndCondition(Condition first, Condition second) throws CSSException {
        if (first instanceof Filter && second instanceof Filter) {
            return new MultipleFilter((Filter) first, (Filter) second);
        } else {
            return new MultipleFilter(CSSUtil.convert(first), CSSUtil.convert(second));
        }
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createOrCondition(org.w3c.css.sac.Condition,
     *      org.w3c.css.sac.Condition)
     */
    public CombinatorCondition createOrCondition(Condition first, Condition second) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createNegativeCondition(org.w3c.css.sac.Condition)
     */
    public NegativeCondition createNegativeCondition(Condition condition) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createPositionalCondition(int, boolean, boolean)
     */
    public PositionalCondition createPositionalCondition(int position, boolean typeNode, boolean type)
            throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createAttributeCondition(java.lang.String,
     *      java.lang.String, boolean, java.lang.String)
     */
    public AttributeCondition createAttributeCondition(String localName, String namespaceURI, boolean specified, String value)
            throws CSSException {
        return new AttributeFilter(localName, value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createIdCondition(java.lang.String)
     */
    public AttributeCondition createIdCondition(String value) throws CSSException {
        return new IDFilter(value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createLangCondition(java.lang.String)
     */
    public LangCondition createLangCondition(String lang) throws CSSException {
        return new LangFilter(lang);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createOneOfAttributeCondition(java.lang.String,
     *      java.lang.String, boolean, java.lang.String)
     */
    public AttributeCondition createOneOfAttributeCondition(String localName, String namespaceURI, boolean specified, String value)
            throws CSSException {
        return new TokensFilter(localName, value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createBeginHyphenAttributeCondition(java.lang.String,
     *      java.lang.String, boolean, java.lang.String)
     */
    public AttributeCondition createBeginHyphenAttributeCondition(String localName, String namespaceURI, boolean specified, String value)
            throws CSSException {
        return new HyphenTokensFilter(null, namespaceURI, localName, value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createClassCondition(java.lang.String,
     *      java.lang.String)
     */
    public AttributeCondition createClassCondition(String namespaceURI, String value) throws CSSException {
        return new ClassFilter(value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createPseudoClassCondition(java.lang.String,
     *      java.lang.String)
     */
    public AttributeCondition createPseudoClassCondition(String namespaceURI, String value) throws CSSException {
        if (value.equals(FirstChildFilter.SINGLETON.getValue())) {
            return FirstChildFilter.SINGLETON;
        }

        if (value.equals(FirstTypedFilter.SINGLETON.getValue())) {
            return FirstTypedFilter.SINGLETON;
        }

        if (value.equals(LastChildFilter.SINGLETON.getValue())) {
            return LastChildFilter.SINGLETON;
        }

        if (value.equals(LastTypedFilter.SINGLETON.getValue())) {
            return LastTypedFilter.SINGLETON;
        }

        if (value.equals(OnlyChildFilter.SINGLETON.getValue())) {
            return OnlyChildFilter.SINGLETON;
        }

        if (value.equals(OnlyTypedFilter.SINGLETON.getValue())) {
            return OnlyTypedFilter.SINGLETON;
        }

        if (value.equals(EmptyFilter.SINGLETON.getValue())) {
            return EmptyFilter.SINGLETON;
        }

        if (value.equals(RootFilter.SINGLETON.getValue())) {
            return RootFilter.SINGLETON;
        }
        return new PseudoClassFilter(value);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createOnlyChildCondition()
     */
    public Condition createOnlyChildCondition() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createOnlyTypeCondition()
     */
    public Condition createOnlyTypeCondition() throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * @see org.w3c.css.sac.ConditionFactory#createContentCondition(java.lang.String)
     */
    public ContentCondition createContentCondition(String data) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }
}
