/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.CSS;
import org.trix.cuery.filter.Filter;

/**
 * PropertyDescription is Rule Set with only one Selector basically. But PropertyDescription has
 * some metadata of itself.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: PropertyDescription.java,v 1.01 2006/03/24 16:35:45 Teletha Exp $
 */
public final class PropertyDescription {

    /** The filter. */
    protected Filter filter;

    /** The origin. */
    protected int origin;

    /** The position of this property. */
    protected int position;

    /** The actual property. */
    protected Property property;

    /**
     * Create PropertyDescription instance.
     * 
     * @param filter A selector od this rule set.
     * @param origin A value for the origin of this rule set.
     * @param position A position of this rule set.
     * @param property A property of this rule set.
     */
    public PropertyDescription(Filter filter, int origin, int position, Property property) {
        this.filter = filter;
        this.origin = origin;
        this.position = position;
        this.property = property;
    }

    /**
     * Return a selector of this rule set.
     * 
     * @return A filter as selector.
     */
    public Filter getFilter() {
        return filter;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Filter : ");
        buffer.append(filter.toString());
        buffer.append("   Origin : ");

        switch (origin) {
        case CSS.ORIGIN_AGENT:
            buffer.append("Agent");
            break;

        case CSS.ORIGIN_AUTHOR:
            buffer.append("Author");
            break;
        case CSS.ORIGIN_USER:
            buffer.append("User");
            break;
        default:
            break;
        }

        buffer.append("   Position : ");
        buffer.append(position);
        buffer.append("   Property : ");
        buffer.append(property.toString());

        return buffer.toString();
    }
}
