/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: InheritableProperty.java,v 1.01 2005/12/06 15:04:56 Teletha Exp $
 */
public class InheritableProperty extends AbstractProperty {

    /** The root property. */
    public static final InheritableProperty ROOT = new InheritableProperty(null);

    /** The parent property. */
    private Property parent;

    /**
     * Create InheritableProperty instance.
     * 
     * @param parent A parent property.
     */
    public InheritableProperty(Property parent) {
        this.parent = parent;
    }

    /**
     * @see org.trix.cuery.property.Property#getValue(java.lang.String)
     */
    public CSSValue getValue(String name) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);

        // check root
        if (parent == null) {
            return definition.getComputedValue(definition.getInitialValue(), this, this);
        }

        // check property definition
        if (definition.isInheritable()) {
            return parent.getValue(name);
        }
        return definition.getComputedValue(definition.getInitialValue(), this, parent);
    }

    /**
     * @see org.trix.cuery.property.Property#isImportant(java.lang.String)
     */
    public boolean isImportant(String name) {
        // check parent
        if (parent == null) {
            return false;
        }

        PropertyDefinition definition = PropertyRegistry.getDefinition(name);

        // check property definition
        if (definition.isInheritable()) {
            return parent.isImportant(name);
        }
        return false;
    }
}
