/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.dom.stylesheets;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: StyleSheetListImpl.java,v 1.01 2005/08/23 10:19:21 Teletha Exp $
 */
public class StyleSheetListImpl implements StyleSheetList {

    /** The list. */
    private List list = new ArrayList(4);

    /**
     * @see org.w3c.dom.stylesheets.StyleSheetList#getLength()
     */
    public int getLength() {
        return list.size();
    }

    /**
     * @see org.w3c.dom.stylesheets.StyleSheetList#item(int)
     */
    public StyleSheet item(int index) {
        return (StyleSheet) list.get(index);
    }

    /**
     * Add stylesheet.
     * 
     * @param styleSheet A style sheet.
     */
    public void addStyleSheet(StyleSheet styleSheet) {
        list.add(styleSheet);
    }

}
