/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.css;

import java.io.IOException;

import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.util.URIUtil;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ImportablePipe.java,v 1.0 2005/08/05 19:52:50 Teletha Exp $
 */
public class ImportablePipe extends AbstractCSSPipe {

    /** The base uri. */
    private String base;

    /**
     * Create ImportablePipe instance.
     * 
     * @param base A base uri.
     */
    public ImportablePipe(String base) {
        this.base = base;
    }

    /**
     * @see org.trix.cuery.css.AbstractCSSPipe#importStyle(java.lang.String,
     *      org.w3c.css.sac.SACMediaList, java.lang.String)
     */
    public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
        String normalizedURI = URIUtil.getNormalizedURI(base, uri);

        // check uri
        if (normalizedURI == null || normalizedURI.length() == 0) {
            throw new CSSException("This uri is invalid.");
        }

        // parse
        try {
            CSSPipe pipe = new ImportablePipe(normalizedURI);
            pipe.setConsumer(consumer);

            Parser parser = new CueryParser();
            parser.setDocumentHandler(pipe);
            parser.parseStyleSheet(normalizedURI);
        } catch (IOException e) {
            throw new CSSException(e.getMessage());
        }
    }
}
