/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;

/**
 * The object that implements this interface can be called with the parser that convert URI used
 * with import rule or xml-stylesheet instruction into the InputSource object.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: URIResolver.java,v 1.0 2005/11/04 21:48:01 Teletha Exp $
 */
public interface URIResolver {

    /**
     * When the css parser detects import rule or xml-stylesheet instruction, it is called from the
     * parser.
     * 
     * @param href A css absolute or relative uri.
     * @param base A base absolute uri.
     * @return A create InputSource. If the uri can't be resolved, return null.
     * @throws CSSException When the error occurs when it started resolving URI.
     */
    InputSource resolve(String href, String base) throws CSSException;
}
