/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.trix.cuery.dom.stylesheets.StyleSheetImpl;
import org.trix.cuery.dom.stylesheets.StyleSheetListImpl;
import org.trix.cuery.filter.ClassFilter;
import org.trix.cuery.filter.ElementFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.filter.IDFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.stylesheets.StyleSheetList;

public final class DOMUtil {
    public static final Element[] EMPTY_ELEMETS = new Element[0];
    private static final String KEY_VANISHING_NODE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.trix.cuery.util.DOMUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY_VANISHING_NODE = String.valueOf(clazz.getName()) + "Vanishing";
    }

    private DOMUtil() {
    }

    public static Set getElementsByClassName(Node source, String className) {
        return DOMUtil.retrieveElements(source, new ClassFilter(className), true);
    }

    public static Element getElementById(Node source, String id) {
        Set result = DOMUtil.retrieveElements(source, new IDFilter(id), true);
        if (result.size() == 1) {
            return (Element)result.iterator().next();
        }
        return null;
    }

    public static Set getElementsByTagName(Node source, String tagName) {
        return DOMUtil.retrieveElements(source, new ElementFilter(tagName), true);
    }

    public static Element getParentElement(Node target) {
        if (target == null) {
            return null;
        }
        Node parent = target.getParentNode();
        if (DOMUtil.isValidElement(parent)) {
            return (Element)parent;
        }
        return null;
    }

    public static Element getPreviousElement(Node source) {
        if (source == null) {
            return null;
        }
        Node previous = source.getPreviousSibling();
        if (DOMUtil.isValidElement(previous)) {
            return (Element)previous;
        }
        return DOMUtil.getPreviousElement(previous);
    }

    public static Element getNextElement(Node source) {
        if (source == null) {
            return null;
        }
        Node next = source.getNextSibling();
        if (DOMUtil.isValidElement(next)) {
            return (Element)next;
        }
        return DOMUtil.getNextElement(next);
    }

    public static StyleSheetList getStylesheets(Document document) {
        NodeList children = document.getChildNodes();
        StyleSheetListImpl list = new StyleSheetListImpl();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 7) {
                ProcessingInstruction pi = (ProcessingInstruction)child;
                list.addStyleSheet(new StyleSheetImpl(pi));
            }
            ++i;
        }
        return list;
    }

    public static int getPosition(Element element) {
        if (element == null) {
            return -1;
        }
        Node parent = element.getParentNode();
        if (!DOMUtil.isValidElement(parent)) {
            return -1;
        }
        int position = 1;
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node current = nodeList.item(i);
            if (DOMUtil.isValidElement(current)) {
                if (current == element) {
                    return position;
                }
                ++position;
            }
            ++i;
        }
        return -1;
    }

    public static int getTypedPosition(Element element) {
        if (element == null) {
            return -1;
        }
        Node parent = element.getParentNode();
        if (!DOMUtil.isValidElement(parent)) {
            return -1;
        }
        int position = 1;
        String ns = element.getNamespaceURI();
        String name = element.getLocalName();
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (DOMUtil.isValidElement(node)) {
                Element current = (Element)node;
                if ((ns == null || ns.equals(current.getNamespaceURI())) && current.getLocalName().equals(name)) {
                    if (current == element) {
                        return position;
                    }
                    ++position;
                }
            }
            ++i;
        }
        return -1;
    }

    public static boolean hasToken(Element target, String name, String token) {
        if (target == null || name == null || name.length() == 0 || token == null || token.length() == 0) {
            return false;
        }
        String attribute = target.getAttribute(name);
        if (attribute == null || attribute.length() < token.length()) {
            return false;
        }
        String[] values = attribute.split(" ");
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(token)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Set retrieveElements(Node source, Filter filter, boolean descendant) {
        if (source == null) {
            return Collections.EMPTY_SET;
        }
        if (source.getNodeType() == 9 || source.getNodeType() == 1) {
            HashSet container = new HashSet();
            DOMUtil.retrieveElements(container, source, filter, descendant);
            return container;
        }
        return Collections.EMPTY_SET;
    }

    private static void retrieveElements(Set container, Node source, Filter filter, boolean descendant) {
        if (!source.hasChildNodes()) {
            return;
        }
        NodeList children = source.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (DOMUtil.isValidElement(child)) {
                Element element = (Element)child;
                if (descendant) {
                    DOMUtil.retrieveElements(container, element, filter, descendant);
                }
                if (filter.accept(element)) {
                    container.add(element);
                }
            }
            ++i;
        }
    }

    public static void setVanishing(Node node) {
        if (node == null) {
            return;
        }
        node.setUserData(KEY_VANISHING_NODE, KEY_VANISHING_NODE, null);
    }

    private static boolean isValidElement(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        return node.getUserData(KEY_VANISHING_NODE) == null;
    }
}

