/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.MultipleFilter;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static boolean hasFilter(Condition condition, Class clazz) {
        if (condition == null || clazz == null) {
            return false;
        }
        if (clazz.isAssignableFrom(condition.getClass())) {
            return true;
        }
        if (condition instanceof MultipleFilter) {
            MultipleFilter filter = (MultipleFilter)condition;
            if (FilterUtil.hasFilter(filter.getFirstCondition(), clazz)) {
                return true;
            }
            if (FilterUtil.hasFilter(filter.getSecondCondition(), clazz)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasFilter(Selector selector, Class clazz) {
        if (selector == null || clazz == null) {
            return false;
        }
        switch (selector.getSelectorType()) {
            case 0: {
                ConditionalSelector conditional = (ConditionalSelector)selector;
                return FilterUtil.hasFilter(conditional.getCondition(), clazz);
            }
            case 10: 
            case 11: {
                DescendantSelector descendant = (DescendantSelector)selector;
                if (FilterUtil.hasFilter((Selector)descendant.getSimpleSelector(), clazz)) {
                    return true;
                }
                return FilterUtil.hasFilter(descendant.getAncestorSelector(), clazz);
            }
            case 12: 
            case 13: {
                SiblingSelector sibling = (SiblingSelector)selector;
                if (FilterUtil.hasFilter((Selector)sibling.getSiblingSelector(), clazz)) {
                    return true;
                }
                return FilterUtil.hasFilter(sibling.getSelector(), clazz);
            }
        }
        return false;
    }
}

