/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.trix.cuery.util.CSSUtil;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChildFilter
implements Filter,
DescendantSelector {
    protected Filter parent;
    protected Filter filter;

    public ChildFilter(Selector parent, SimpleSelector simpleSelector) {
        this.parent = CSSUtil.convert(parent);
        this.filter = CSSUtil.convert((Selector)simpleSelector);
    }

    public Selector getAncestorSelector() {
        return this.parent;
    }

    public SimpleSelector getSimpleSelector() {
        return (SimpleSelector)this.filter;
    }

    public boolean accept(Element target) {
        if (!this.filter.accept(target)) {
            return false;
        }
        Node node = target.getParentNode();
        if (node == null || node.getNodeType() != 1) {
            return false;
        }
        return this.parent.accept((Element)node);
    }

    public int getSpecificity() {
        return this.parent.getSpecificity() + this.filter.getSpecificity();
    }

    public short getSelectorType() {
        return 11;
    }

    public short getConditionType() {
        return 0;
    }

    public String toString() {
        return this.parent + " > " + this.filter;
    }
}

