/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.trix.cuery.CSSQuery;
import org.trix.cuery.StyleContext;
import org.trix.cuery.URIResolver;
import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.css.CSSPipe;
import org.trix.cuery.filter.AcceptFilter;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.property.CascadableProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDescription;
import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.sac.LocatorImpl;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;
import org.trix.cuery.util.I18nUtil;
import org.trix.cuery.util.URIUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.xml.sax.SAXException;

public class CSSWeaver {
    private static CueryParser parser = new CueryParser();
    private List agents = new ArrayList();
    private List authors = new ArrayList();
    private List users = new ArrayList();
    private URIResolver resolver;
    private boolean awareXMLStylesheet = false;
    private boolean awareDOMMutarion = false;

    public void addAgentStylesheet(InputSource source) throws IOException {
        this.addAgentStylesheet(source, null);
    }

    public void addAgentStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        if (source == null) {
            return;
        }
        StylesheetInfo info = new StylesheetInfo();
        info.pipe = pipe;
        info.source = source;
        this.agents.add(info);
    }

    public void addAuthorStylesheet(InputSource source) throws IOException {
        this.addAuthorStylesheet(source, null);
    }

    public void addAuthorStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        if (source == null) {
            return;
        }
        StylesheetInfo info = new StylesheetInfo();
        info.pipe = pipe;
        info.source = source;
        this.authors.add(info);
    }

    public void addUserStylesheet(InputSource source) throws IOException {
        this.addUserStylesheet(source, null);
    }

    public void addUserStylesheet(InputSource source, CSSPipe pipe) throws IOException {
        if (source == null) {
            return;
        }
        StylesheetInfo info = new StylesheetInfo();
        info.pipe = pipe;
        info.source = source;
        this.users.add(info);
    }

    public Document apply(String path) throws IOException {
        return this.apply(new File(path));
    }

    public Document apply(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return this.apply(builder.parse(file));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Document apply(Document document) {
        StylesheetInfo info;
        if (document == null) {
            throw new IllegalArgumentException("The input document is null.");
        }
        PropertyProcessor processor = new PropertyProcessor();
        processor.origin = 1;
        int i = 0;
        while (i < this.agents.size()) {
            info = (StylesheetInfo)this.agents.get(i);
            if (info.pipe == null) {
                parser.setDocumentHandler(processor);
            } else {
                info.pipe.setConsumer(processor);
                parser.setDocumentHandler(info.pipe);
            }
            try {
                parser.parseStyleSheet(info.source);
            }
            catch (CSSException e) {
                System.out.println((Object)e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
            ++i;
        }
        processor.origin = 3;
        i = 0;
        while (i < this.authors.size()) {
            info = (StylesheetInfo)this.authors.get(i);
            if (info.pipe == null) {
                parser.setDocumentHandler(processor);
            } else {
                info.pipe.setConsumer(processor);
                parser.setDocumentHandler(info.pipe);
            }
            try {
                parser.parseStyleSheet(info.source);
            }
            catch (CSSException e) {
                System.out.println((Object)e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
            ++i;
        }
        if (this.awareXMLStylesheet) {
            StyleSheetList stylesheets = DOMUtil.getStylesheets(document);
            parser.setDocumentHandler(processor);
            int i2 = 0;
            while (i2 < stylesheets.getLength()) {
                StyleSheet stylesheet = stylesheets.item(i2);
                if (stylesheet.getType().equals("text/css")) {
                    try {
                        InputSource source = this.getResolver().resolve(stylesheet.getHref(), document.getDocumentURI());
                        parser.parseStyleSheet(source);
                    }
                    catch (IOException e) {
                        System.out.println(e);
                    }
                    catch (CSSException e) {
                        System.out.println((Object)e);
                    }
                }
                ++i2;
            }
        }
        processor.origin = 2;
        i = 0;
        while (i < this.users.size()) {
            StylesheetInfo info2 = (StylesheetInfo)this.users.get(i);
            if (info2.pipe == null) {
                parser.setDocumentHandler(processor);
            } else {
                info2.pipe.setConsumer(processor);
                parser.setDocumentHandler(info2.pipe);
            }
            try {
                parser.parseStyleSheet(info2.source);
            }
            catch (CSSException e) {
                System.out.println((Object)e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
            ++i;
        }
        CSSQuery query = new CSSQuery(document);
        processor.weave(query);
        if (this.awareDOMMutarion) {
            if (document.getImplementation().hasFeature("Events", "2.0")) {
                EventTarget target = (EventTarget)((Object)document);
                PropertyProcessor listener = processor;
                target.addEventListener("DOMAttrModified", listener, false);
                target.addEventListener("DOMNodeInserted", listener, true);
                target.addEventListener("DOMNodeRemoved", listener, false);
                target.addEventListener("DOMCharacterDataModified", listener, false);
                target.addEventListener("CueryUIPseudoClassAssigned", listener, false);
                target.addEventListener("CueryUIPseudoClassDeprived", listener, false);
            } else {
                LocatorImpl locator = new LocatorImpl(document.getDocumentURI(), 0, 0);
                processor.error(new CSSParseException(I18nUtil.getText("weaver.domMutation"), (Locator)locator));
            }
        }
        return document;
    }

    public void awareXMLStylesheet(boolean aware) {
        this.awareXMLStylesheet = aware;
    }

    public void awareDOMMutation(boolean aware) {
        this.awareDOMMutarion = aware;
    }

    public void setURIResolver(URIResolver resolver) {
        if (resolver == null) {
            return;
        }
        this.resolver = resolver;
    }

    private URIResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new SimpleResolver();
        }
        return this.resolver;
    }

    protected final class PropertyProcessor
    extends AbstractCSSConsumer
    implements EventListener {
        private List descriptions = new ArrayList();
        private String uri;
        private int origin = 3;
        private int position;
        private SimpleProperty property;

        public PropertyProcessor() {
            this.position = -1;
        }

        public PropertyProcessor(PropertyProcessor parent) {
            this.position = parent.position;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            this.property.setProperty(name, (CSSValue)value, important);
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.property = new SimpleProperty();
            ++this.position;
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            int i = 0;
            while (i < selectorList.getLength()) {
                PropertyDescription description = new PropertyDescription((Filter)selectorList.item(i), this.origin, this.position, this.property);
                this.descriptions.add(description);
                ++i;
            }
        }

        public void importStyle(String uri, SACMediaList mediaList, String defaultNamespaceURI) throws CSSException {
            InputSource source = CSSWeaver.this.getResolver().resolve(uri, this.uri);
            try {
                CueryParser parser = new CueryParser();
                parser.setDocumentHandler(this);
                parser.parseStyleSheet(source);
            }
            catch (CSSException e) {
                System.out.println((Object)e);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }

        public void handleEvent(Event event) {
            Node target;
            Damager damager;
            block16: {
                String type;
                block18: {
                    block17: {
                        block15: {
                            damager = null;
                            type = event.getType();
                            target = (Node)((Object)event.getTarget());
                            if (!type.equals("DOMAttrModified")) break block15;
                            damager = AttributeModifyDamager.SINGLETON;
                            break block16;
                        }
                        if (!type.equals("DOMNodeInserted")) break block17;
                        switch (target.getNodeType()) {
                            case 1: {
                                damager = InsertDamager.SINGLETON;
                                break block16;
                            }
                            case 3: {
                                damager = TextModifyDamager.SINGLETON;
                                break block16;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (!type.equals("DOMNodeRemoved")) break block18;
                    switch (target.getNodeType()) {
                        case 1: {
                            damager = RemoveDamager.SINGLETON;
                            break block16;
                        }
                        case 3: {
                            damager = TextModifyDamager.SINGLETON;
                            break block16;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (type.equals("DOMCharacterDataModified")) {
                    damager = RemoveDamager.SINGLETON;
                } else if (type.equals("CueryUIPseudoClassAssigned")) {
                    damager = PseudoClassModifyDamager.SINGLETON;
                } else if (type.equals("CueryUIPseudoClassDeprived")) {
                    damager = PseudoClassModifyDamager.SINGLETON;
                } else {
                    return;
                }
            }
            Iterator iterator = damager.getDamegeRegion(target).iterator();
            while (iterator.hasNext()) {
                this.update((Element)iterator.next());
            }
        }

        private void weave(CSSQuery query) {
            if (query == null) {
                return;
            }
            int i = 0;
            while (i < this.descriptions.size()) {
                PropertyDescription description = (PropertyDescription)this.descriptions.get(i);
                Set elements = query.select(description.getFilter());
                Iterator iterator = elements.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    CascadableProperty cascadable = (CascadableProperty)element.getUserData(StyleContext.KEY_PROPERTY);
                    if (cascadable == null) {
                        cascadable = new CascadableProperty(element);
                        element.setUserData(StyleContext.KEY_PROPERTY, cascadable, null);
                    }
                    cascadable.addProperty(description);
                }
                ++i;
            }
        }

        private void update(Element element) {
            Property previous = StyleContext.getProperty(element);
            CascadableProperty property = null;
            if (previous instanceof CascadableProperty) {
                property = (CascadableProperty)previous;
                property.clear();
            }
            int i = 0;
            while (i < this.descriptions.size()) {
                PropertyDescription description = (PropertyDescription)this.descriptions.get(i);
                if (description.getFilter().accept(element)) {
                    if (property == null) {
                        property = new CascadableProperty(element);
                        element.setUserData(StyleContext.KEY_PROPERTY, property, null);
                    }
                    property.addProperty(description);
                }
                ++i;
            }
            StyleContext context = StyleContext.getContext(element);
            if (!context.hasListener()) {
                return;
            }
            if (property == null) {
                return;
            }
            context.notifyListener(property);
        }
    }

    private static interface Damager {
        public Set getDamegeRegion(Node var1);
    }

    private static final class InsertDamager
    implements Damager {
        private static final InsertDamager SINGLETON = new InsertDamager();

        InsertDamager() {
        }

        public Set getDamegeRegion(Node node) {
            HashSet<Node> container = new HashSet<Node>();
            Element parent = DOMUtil.getParentElement(node);
            if (parent != null) {
                container.add(parent);
                NodeList list = parent.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node child = list.item(i);
                    if (child.getNodeType() == 1) {
                        container.add((Element)child);
                    }
                    ++i;
                }
            } else {
                container.add(node);
            }
            container.addAll(DOMUtil.retrieveElements(node, AcceptFilter.SINGLETON, true));
            return container;
        }
    }

    private static final class RemoveDamager
    implements Damager {
        private static final RemoveDamager SINGLETON = new RemoveDamager();

        RemoveDamager() {
        }

        public Set getDamegeRegion(Node node) {
            HashSet<Element> container = new HashSet<Element>();
            DOMUtil.setVanishing(node);
            Element parent = DOMUtil.getParentElement(node);
            if (parent != null) {
                container.add(parent);
                NodeList list = parent.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node child = list.item(i);
                    if (child.getNodeType() == 1 && child != node) {
                        container.add((Element)child);
                    }
                    ++i;
                }
            }
            return container;
        }
    }

    private static final class TextModifyDamager
    implements Damager {
        private static final TextModifyDamager SINGLETON = new TextModifyDamager();

        TextModifyDamager() {
        }

        public Set getDamegeRegion(Node node) {
            Node parent = DOMUtil.getParentElement(node);
            if (parent == null) {
                return Collections.EMPTY_SET;
            }
            HashSet<Element> container = new HashSet<Element>();
            while (parent != null) {
                if (parent.getNodeType() == 1) {
                    container.add((Element)parent);
                }
                parent = parent.getNextSibling();
            }
            return container;
        }
    }

    private static final class AttributeModifyDamager
    implements Damager {
        private static final AttributeModifyDamager SINGLETON = new AttributeModifyDamager();

        AttributeModifyDamager() {
        }

        public Set getDamegeRegion(Node node) {
            HashSet<Node> container = new HashSet<Node>();
            container.addAll(DOMUtil.retrieveElements(node, AcceptFilter.SINGLETON, true));
            while (node != null) {
                if (node.getNodeType() == 1) {
                    container.add(node);
                }
                node = node.getNextSibling();
            }
            return container;
        }
    }

    private static final class PseudoClassModifyDamager
    implements Damager {
        private static final PseudoClassModifyDamager SINGLETON = new PseudoClassModifyDamager();

        PseudoClassModifyDamager() {
        }

        public Set getDamegeRegion(Node node) {
            HashSet<Node> container = new HashSet<Node>();
            container.addAll(DOMUtil.retrieveElements(node, AcceptFilter.SINGLETON, true));
            while (node != null) {
                if (node.getNodeType() == 1) {
                    container.add(node);
                }
                node = node.getNextSibling();
            }
            return container;
        }
    }

    private static final class SimpleResolver
    implements URIResolver {
        SimpleResolver() {
        }

        public InputSource resolve(String href, String base) throws CSSException {
            try {
                return CSSUtil.getSource(URIUtil.getNormalizedURI(base, href));
            }
            catch (IOException e) {
                throw new CSSException((Exception)e);
            }
        }
    }

    private static final class StylesheetInfo {
        private InputSource source;
        private CSSPipe pipe;

        StylesheetInfo() {
        }
    }
}

