/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: RectFunctionTest.java,v 1.0 2005/08/10 15:35:53 Teletha Exp $
 */
public class RectFunctionTest extends TestCase {

    private static RectFunction rect;

    static {
        CSSValue top = new EMLength("3.2", null);
        CSSValue comma1 = new CSSOperator(",", top);
        CSSValue right = new PixelLength("20", comma1);
        CSSValue comma2 = new CSSOperator(",", right);
        CSSValue bottom = new EMLength("-2", comma2);
        CSSValue comma3 = new CSSOperator(",", bottom);
        new EMLength("0", comma3);

        rect = new RectFunction(top, null);
    }

    /*
     * Test method for 'org.trix.cuery.value.RectFunction.getBottom()'
     */
    public void testGetBottom() {
        assertEquals("-2em", rect.getBottom().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.RectFunction.getLeft()'
     */
    public void testGetLeft() {
        assertEquals("0em", rect.getLeft().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.RectFunction.getRight()'
     */
    public void testGetRight() {
        assertEquals("20px", rect.getRight().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.RectFunction.getTop()'
     */
    public void testGetTop() {
        assertEquals("3.2em", rect.getTop().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSFunction.getCssText()'
     */
    public void testGetCssText() {
        assertEquals("rect(3.2em,20px,-2em,0em)", rect.getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSFunction.getStringValue()'
     */
    public void testGetStringValue() {
        assertEquals("3.2em,20px,-2em,0em", rect.getStringValue());
    }

}
