/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.util;

import java.io.File;
import java.net.URI;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: URIUtil.java,v 1.0 2005/08/15 9:32:01 Teletha Exp $
 */
public final class URIUtil {

    /**
     * Avoid creating URIUtil instance.
     */
    private URIUtil() {
    }

    /**
     * Resolve uri from base uri.
     * 
     * @param base A base uri.
     * @param uri A target uri.
     * @return A resolved abusolute uri.
     */
    public static String getNormalizedURI(String base, String uri) {
        String normalizedURI = "";

        try {
            normalizedURI = new URI(uri).toURL().toExternalForm();
        } catch (Exception e) {
            File parent = new File(base);

            if (!parent.isDirectory()) {
                parent = parent.getParentFile();
            }
            normalizedURI = new File(parent, uri).getPath();
        }
        return normalizedURI;
    }
}
