/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractProperty.java,v 1.01 2005/08/25 21:14:00 Teletha Exp $
 */
public abstract class AbstractProperty implements Property {

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String)
     */
    public String getValueAsString(String name) {
        return getValueAsString(name, null);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsString(java.lang.String, java.lang.String)
     */
    public String getValueAsString(String name, String defaultValue) {
        CSSValue value = getValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getStringValue();
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String)
     */
    public float getValueAsFloat(String name) {
        return getValueAsFloat(name, 0);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsFloat(java.lang.String, float)
     */
    public float getValueAsFloat(String name, float defaultValue) {
        CSSValue value = getValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getFloatValue();
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsInteger(java.lang.String)
     */
    public int getValueAsInteger(String name) {
        return getValueAsInteger(name, 0);
    }

    /**
     * @see org.trix.cuery.property.Property#getValueAsInteger(java.lang.String, int)
     */
    public int getValueAsInteger(String name, int defaultValue) {
        CSSValue value = getValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getIntegerValue();
    }

}
