/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import java.math.BigDecimal;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.value.CSSLength;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.CentimeterLength;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.EXLength;
import org.trix.cuery.value.InchLength;
import org.trix.cuery.value.MillimeterLength;
import org.trix.cuery.value.PicaLength;
import org.trix.cuery.value.PixelLength;
import org.trix.cuery.value.PointLength;

public final class ValueUtil {
    public static final PointLength ZERO_POINT = new PointLength(0.0f);
    private static final int SCALE = 1;

    private ValueUtil() {
    }

    public static PointLength convertToPointLength(CSSLength length) {
        return new PointLength(ValueUtil.convertToPointLength(length.getFloatValue(), length.getLexicalUnitType()));
    }

    public static float convertToPointLength(float value, short type) {
        float result;
        switch (type) {
            case 19: {
                result = 12.0f * value / 2.54f;
                break;
            }
            case 18: {
                result = 72.0f * value;
                break;
            }
            case 20: {
                result = 12.0f * value / 25.4f;
                break;
            }
            case 22: {
                result = 12.0f * value;
                break;
            }
            case 17: {
                result = 72.0f * value / (float)PropertyRegistry.getFontConfiguration().getDisplayDPI();
                break;
            }
            case 21: {
                result = value;
                break;
            }
            default: {
                result = value;
            }
        }
        return ValueUtil.round(result);
    }

    public static CSSLength divide(CSSLength length, float scale) {
        if (length == null) {
            return ZERO_POINT;
        }
        return ValueUtil.createCSSLength(length.getLexicalUnitType(), ValueUtil.round(length.getFloatValue() / scale));
    }

    public static boolean isCSSLength(CSSValue value) {
        short type = value.getPrimitiveType();
        return 3 <= type && type <= 10;
    }

    public static boolean isAbsoluteCSSLength(CSSValue value) {
        short type = value.getPrimitiveType();
        return 5 <= type && type <= 10;
    }

    public static CSSLength multiply(CSSLength length, CSSPercentage percentage) {
        if (percentage == null) {
            return ValueUtil.multiply(length, 1.0f);
        }
        return ValueUtil.multiply(length, percentage.floatValue / 100.0f);
    }

    public static CSSLength multiply(CSSLength length, float scale) {
        if (length == null) {
            return ZERO_POINT;
        }
        return ValueUtil.createCSSLength(length.getLexicalUnitType(), ValueUtil.round(length.getFloatValue() * scale));
    }

    private static CSSLength createCSSLength(short type, float value) {
        switch (type) {
            case 19: {
                return new CentimeterLength(value);
            }
            case 15: {
                return new EMLength(value);
            }
            case 16: {
                return new EXLength(value);
            }
            case 18: {
                return new InchLength(value);
            }
            case 20: {
                return new MillimeterLength(value);
            }
            case 22: {
                return new PicaLength(value);
            }
            case 17: {
                return new PixelLength(value);
            }
            case 21: {
                return new PointLength(value);
            }
        }
        return ZERO_POINT;
    }

    public static float round(float value) {
        return new BigDecimal(String.valueOf(value)).setScale(1, 6).floatValue();
    }
}

