/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import org.trix.cuery.value.CSSValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public abstract class AbstractCSSValue
implements CSSValue {
    protected float floatValue;
    protected String stringValue;
    protected CSSValue params;
    private AbstractCSSValue previous;
    private AbstractCSSValue next;
    private int length = 1;
    private int position = 0;

    protected AbstractCSSValue(CSSValue previous) {
        this.previous = (AbstractCSSValue)previous;
        if (previous != null) {
            this.previous.next = this;
            this.length = this.previous.length;
            this.position = this.previous.length;
            this.propagate();
        }
    }

    public CSSValue get(int index) {
        if (index < 0 || this.length - 1 < index) {
            return null;
        }
        AbstractCSSValue current = this;
        while (current != null && index != current.position) {
            if (index > current.position) {
                current = current.next;
                continue;
            }
            if (index >= current.position) continue;
            current = current.previous;
        }
        return current;
    }

    public CSSValue getNextValue() {
        return this.next;
    }

    public CSSValue getPreviousValue() {
        return this.previous;
    }

    public Class getType() {
        return this.getClass();
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previous;
    }

    public int getIntegerValue() {
        return Math.round(this.floatValue);
    }

    public String getDimensionUnitText() {
        return "";
    }

    public String getFunctionName() {
        return "";
    }

    public LexicalUnit getParameters() {
        return this.params;
    }

    public LexicalUnit getSubValues() {
        return this.params;
    }

    public float getFloatValue(short unitType) throws DOMException {
        if (unitType < 1 || 18 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
        return 0.0f;
    }

    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS Counter.");
    }

    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS Rect.");
    }

    public RGBColor getRGBColorValue() throws DOMException {
        throw new DOMException(15, "This value is not a CSS RGBColor.");
    }

    public String getCssText() {
        return this.stringValue;
    }

    public void setCssText(String text) throws DOMException {
    }

    public short getCssValueType() {
        if (this.length == 1) {
            return 1;
        }
        return 2;
    }

    public void setFloatValue(short unitType, float value) throws DOMException {
        if (unitType < 1 || 18 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
    }

    public void setStringValue(short unitType, String value) throws DOMException {
        if (unitType < 19 || 22 < unitType) {
            throw new DOMException(unitType, "This type is out of range.");
        }
    }

    public int getLength() {
        return this.length;
    }

    public org.w3c.dom.css.CSSValue item(int index) {
        return this.get(index);
    }

    public final String toString() {
        return this.getCssText();
    }

    private void propagate() {
        ++this.length;
        if (this.previous != null) {
            this.previous.propagate();
        }
    }
}

