/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property.css2;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.property.config.FontConfiguration;
import org.trix.cuery.value.CSSLength;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.PixelLength;
import org.trix.cuery.value.PointLength;
import org.trix.cuery.value.ValueUtil;

public class FontSizeDefinition
extends PropertyDefinition {
    private static final String[] ABSOLUTE_SIZE = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
    private final List absolutes = new ArrayList(ABSOLUTE_SIZE.length);

    public FontSizeDefinition() {
        FontConfiguration config = PropertyRegistry.getFontConfiguration();
        float medium = config.getMediumFontSize();
        float scale = config.getScalingFactor();
        int i = 0;
        while (i < ABSOLUTE_SIZE.length) {
            float result;
            switch (i) {
                case 0: {
                    result = medium / scale / scale / scale;
                    break;
                }
                case 1: {
                    result = medium / scale / scale;
                    break;
                }
                case 2: {
                    result = medium / scale;
                    break;
                }
                case 3: {
                    result = medium;
                    break;
                }
                case 4: {
                    result = medium * scale;
                    break;
                }
                case 5: {
                    result = medium * scale * scale;
                    break;
                }
                case 6: {
                    result = medium * scale * scale * scale;
                    break;
                }
                default: {
                    result = medium;
                }
            }
            this.absolutes.add(i, new PointLength(ValueUtil.round(result)));
            ++i;
        }
    }

    protected CSSValue computeEMLength(EMLength length, Property property, Property parent) {
        if (parent == null) {
            return this.getComputedValue(this.getInitialValue(), property, parent);
        }
        CSSLength fontSize = (CSSLength)parent.getValue("font-size");
        return ValueUtil.multiply(fontSize, length.getFloatValue());
    }

    protected CSSValue computeIdentifier(Identifier identifier, Property property, Property parent) {
        String value = identifier.getCssText();
        if (value.equals("larger")) {
            return this.getLargerFontSize(parent.getValue(this.name));
        }
        if (value.equals("smaller")) {
            return this.getSmallerFontSize(parent.getValue(this.name));
        }
        return this.getAbsoluteFontSize(value);
    }

    protected CSSValue computePercentage(CSSPercentage percentage, Property property, Property parent) {
        CSSLength fontSize = (CSSLength)parent.getValue("font-size");
        return ValueUtil.multiply(fontSize, percentage);
    }

    protected CSSValue computePixelLength(PixelLength length, Property property, Property parent) {
        return ValueUtil.convertToPointLength(length);
    }

    private PointLength getAbsoluteFontSize(String keyword) {
        if (keyword == null || keyword.length() == 0) {
            return null;
        }
        int index = ArrayUtils.indexOf((Object[])ABSOLUTE_SIZE, (Object)keyword);
        if (index == -1) {
            return null;
        }
        return (PointLength)this.absolutes.get(index);
    }

    private PointLength getLargerFontSize(CSSValue base) {
        if (ValueUtil.isAbsoluteCSSLength(base)) {
            float baseLength = ValueUtil.convertToPointLength(base.getFloatValue(), base.getLexicalUnitType());
            int i = 0;
            while (i < this.absolutes.size()) {
                PointLength point = (PointLength)this.absolutes.get(i);
                if (baseLength < point.getFloatValue()) {
                    return point;
                }
                ++i;
            }
        }
        return null;
    }

    private PointLength getSmallerFontSize(CSSValue base) {
        if (ValueUtil.isAbsoluteCSSLength(base)) {
            float baseLength = ValueUtil.convertToPointLength(base.getFloatValue(), base.getLexicalUnitType());
            int i = this.absolutes.size();
            while (i > 0) {
                PointLength point = (PointLength)this.absolutes.get(i);
                if (baseLength > point.getFloatValue()) {
                    return point;
                }
                --i;
            }
        }
        return null;
    }
}

