/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.trix.cuery.filter.AttributeFilter;
import org.trix.cuery.filter.DenialFIlter;
import org.trix.cuery.filter.FirstNumeralFilter;
import org.trix.cuery.filter.FirstTypedNumeralFilter;
import org.trix.cuery.filter.IndirectAdjacentFilter;
import org.trix.cuery.filter.LastNumeralFilter;
import org.trix.cuery.filter.LastTypedNumeralFilter;
import org.trix.cuery.filter.PrefixMatchFilter;
import org.trix.cuery.filter.SubstringMatchFilter;
import org.trix.cuery.filter.SuffixMatchFilter;
import org.trix.cuery.parser.CueryParserConstants;
import org.trix.cuery.parser.CueryParserTokenManager;
import org.trix.cuery.parser.JavaCharStream;
import org.trix.cuery.parser.ParseException;
import org.trix.cuery.parser.Token;
import org.trix.cuery.sac.ConditionFactoryImpl;
import org.trix.cuery.sac.LocatorImpl;
import org.trix.cuery.sac.SACMediaListImpl;
import org.trix.cuery.sac.SelectorFactoryImpl;
import org.trix.cuery.sac.SelectorListImpl;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.AttrFunction;
import org.trix.cuery.value.CSSColor;
import org.trix.cuery.value.CSSFunction;
import org.trix.cuery.value.CSSNumber;
import org.trix.cuery.value.CSSOperator;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSString;
import org.trix.cuery.value.CSSURI;
import org.trix.cuery.value.CSSUnicodeRange;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.CentimeterLength;
import org.trix.cuery.value.CounterFunction;
import org.trix.cuery.value.CountersFunction;
import org.trix.cuery.value.DegreeAngle;
import org.trix.cuery.value.EMLength;
import org.trix.cuery.value.EXLength;
import org.trix.cuery.value.GradianAngle;
import org.trix.cuery.value.HertzFrequency;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.InchLength;
import org.trix.cuery.value.KiloHertzFrequency;
import org.trix.cuery.value.MillimeterLength;
import org.trix.cuery.value.MillisecondTime;
import org.trix.cuery.value.PicaLength;
import org.trix.cuery.value.PixelLength;
import org.trix.cuery.value.PointLength;
import org.trix.cuery.value.RadianAngle;
import org.trix.cuery.value.RectFunction;
import org.trix.cuery.value.SecondTime;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;

public class CueryParser
implements Parser,
CueryParserConstants {
    private InputSource source;
    private DocumentHandler handler;
    private ErrorHandler errorHandler;
    private SelectorFactory selectorFactory = new SelectorFactoryImpl();
    private ConditionFactory conditionFactory = new ConditionFactoryImpl();
    private Locale locale = Locale.getDefault();
    public CueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[103];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        CueryParser.jj_la1_0();
        CueryParser.jj_la1_1();
        CueryParser.jj_la1_2();
    }

    public CueryParser() {
        this(System.in);
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public void setLocale(Locale locale) throws CSSException {
        if (locale == null) {
            return;
        }
        this.locale = locale;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        if (selectorFactory == null) {
            return;
        }
        this.selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        if (conditionFactory == null) {
            return;
        }
        this.conditionFactory = conditionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            return;
        }
        this.errorHandler = errorHandler;
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        if (uri == null || uri.length() == 0) {
            throw new IOException("Unable to parse a stylesheet because this uri is null.");
        }
        InputSource source = null;
        try {
            source = CSSUtil.getSource(uri);
            this.parseStyleSheet(source);
        }
        finally {
            if (source != null) {
                source.getCharacterStream().close();
            }
        }
    }

    public void parseStyleSheet(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            try {
                this.handler.startDocument(source);
                this.styleSheet();
            }
            catch (ParseException e) {
                throw new CSSException(2, e.getMessage(), (Exception)e);
            }
        }
        finally {
            this.handler.endDocument(source);
        }
    }

    public void parseStyleDeclaration(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            this.parseStyleDeclaration();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            this.parseStyleRule();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public SelectorList parseSelectors(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            return this.selectorList();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            return this.expr();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public boolean parsePriority(InputSource source) throws CSSException, IOException {
        this.initializeParser(source);
        try {
            return this.priority();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public Selector parseSelector(String expression) throws CSSException {
        if (expression == null || expression.length() == 0) {
            throw new CSSException("This selector expression is null.");
        }
        this.ReInit(new StringReader(expression));
        try {
            return this.selector();
        }
        catch (ParseException e) {
            throw new CSSException(2, e.getMessage(), (Exception)e);
        }
    }

    public Locator getLocator() {
        return new LocatorImpl(this.source.getURI(), this.token.beginLine, this.token.beginColumn);
    }

    private void initializeParser(InputSource source) {
        this.source = source;
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            this.ReInit(source.getByteStream(), source.getEncoding());
        } else {
            this.ReInit(reader);
        }
    }

    private void handleError(String message, Exception cause) {
        if (this.errorHandler == null) {
            return;
        }
        CSSParseException exception = new CSSParseException(message, this.source.getURI(), this.token.beginLine, this.token.beginColumn, cause);
        this.errorHandler.warning(exception);
    }

    public final void parseStyleDeclaration() throws ParseException {
        this.jj_consume_token(4);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.declaration();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block16;
                }
            }
            this.jj_consume_token(8);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(35);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    this.declaration();
                    continue block16;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        this.jj_consume_token(5);
    }

    public final void parseStyleRule() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.importRule();
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 47: 
            case 83: {
                this.styleRule();
                break;
            }
            case 30: {
                this.mediaRule();
                break;
            }
            case 31: {
                this.pageRule();
                break;
            }
            case 28: {
                this.fontFaceRule();
                break;
            }
            case 34: {
                this.unknownRule();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void styleSheet() throws ParseException {
        try {
            block57: {
                block56: {
                    block55: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 26: {
                                this.jj_consume_token(26);
                                block48: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 35: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[6] = this.jj_gen;
                                            break block48;
                                        }
                                    }
                                    this.jj_consume_token(35);
                                }
                                this.jj_consume_token(46);
                                block49: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 35: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[7] = this.jj_gen;
                                            break block49;
                                        }
                                    }
                                    this.jj_consume_token(35);
                                }
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_la1[8] = this.jj_gen;
                            }
                        }
                        block50: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: 
                                case 81: 
                                case 82: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[9] = this.jj_gen;
                                    break block55;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: {
                                    this.jj_consume_token(35);
                                    continue block50;
                                }
                                case 81: {
                                    this.jj_consume_token(81);
                                    continue block50;
                                }
                                case 82: {
                                    this.jj_consume_token(82);
                                    continue block50;
                                }
                            }
                            break;
                        }
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    block51: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 29: {
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                break block56;
                            }
                        }
                        this.importRule();
                        block52: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: 
                                case 81: 
                                case 82: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[12] = this.jj_gen;
                                    continue block51;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: {
                                    this.jj_consume_token(35);
                                    continue block52;
                                }
                                case 81: {
                                    this.jj_consume_token(81);
                                    continue block52;
                                }
                                case 82: {
                                    this.jj_consume_token(82);
                                    continue block52;
                                }
                            }
                            break;
                        }
                        break;
                    }
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                block53: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: 
                        case 9: 
                        case 10: 
                        case 16: 
                        case 28: 
                        case 30: 
                        case 31: 
                        case 34: 
                        case 47: 
                        case 83: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block57;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: 
                        case 9: 
                        case 10: 
                        case 16: 
                        case 47: 
                        case 83: {
                            this.styleRule();
                            break;
                        }
                        case 30: {
                            this.mediaRule();
                            break;
                        }
                        case 31: {
                            this.pageRule();
                            break;
                        }
                        case 28: {
                            this.fontFaceRule();
                            break;
                        }
                        case 34: {
                            this.unknownRule();
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block54: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: 
                            case 81: 
                            case 82: {
                                break;
                            }
                            default: {
                                this.jj_la1[16] = this.jj_gen;
                                continue block53;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: {
                                this.jj_consume_token(35);
                                continue block54;
                            }
                            case 81: {
                                this.jj_consume_token(81);
                                continue block54;
                            }
                            case 82: {
                                this.jj_consume_token(82);
                                continue block54;
                            }
                        }
                        break;
                    }
                    break;
                }
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(0);
        }
        catch (ParseException e) {
            this.skipBlock(e);
            this.styleSheet();
        }
    }

    public final void importRule() throws ParseException {
        Token token;
        SACMediaListImpl mediaList = new SACMediaListImpl();
        this.jj_consume_token(29);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                token = this.jj_consume_token(46);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block14;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.mediaList(mediaList);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        this.handler.importStyle(token.image, (SACMediaList)mediaList, null);
    }

    public final void mediaRule() throws ParseException {
        boolean start = false;
        SACMediaListImpl media = new SACMediaListImpl();
        try {
            this.jj_consume_token(30);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(35);
            }
            this.mediaList(media);
            start = true;
            this.handler.startMedia((SACMediaList)media);
            this.jj_consume_token(4);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(35);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 9: 
                case 10: 
                case 16: 
                case 31: 
                case 34: 
                case 47: 
                case 83: {
                    this.mediaRuleList();
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                }
            }
            this.jj_consume_token(5);
        }
        finally {
            if (start) {
                this.handler.endMedia((SACMediaList)media);
            }
        }
    }

    public final void unknownRule() throws ParseException {
        this.jj_consume_token(34);
        String token = this.skip();
        this.handler.ignorableAtRule(token);
    }

    public final void mediaList(SACMediaListImpl list) throws ParseException {
        String medium = this.medium();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(6);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(35);
            }
            list.appendMedium(medium);
            medium = this.medium();
        }
        list.appendMedium(medium);
    }

    public final void mediaRuleList() throws ParseException {
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 9: 
                case 10: 
                case 16: 
                case 47: 
                case 83: {
                    this.styleRule();
                    break;
                }
                case 31: {
                    this.pageRule();
                    break;
                }
                case 34: {
                    this.unknownRule();
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(35);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 9: 
                case 10: 
                case 16: 
                case 31: 
                case 34: 
                case 47: 
                case 83: {
                    continue block11;
                }
            }
            break;
        }
        this.jj_la1[29] = this.jj_gen;
    }

    public final void mediaRuleSingle() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 47: 
            case 83: {
                this.styleRule();
                break;
            }
            case 31: {
                this.pageRule();
                break;
            }
            case 34: {
                this.unknownRule();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String medium() throws ParseException {
        Token token = this.jj_consume_token(47);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(35);
        }
        return token.image;
    }

    public final void pageRule() throws ParseException {
        Token t = null;
        String s = null;
        boolean start = false;
        try {
            this.jj_consume_token(31);
            block36: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block36;
                    }
                }
                this.jj_consume_token(35);
            }
            block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 47: {
                    if (this.jj_2_1(2)) {
                        t = this.jj_consume_token(47);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[33] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.jj_consume_token(35);
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 47: {
                            t = this.jj_consume_token(47);
                            s = this.pseudoPage();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 35: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[34] = this.jj_gen;
                                        break block4;
                                    }
                                }
                                this.jj_consume_token(35);
                            }
                        }
                        case 9: {
                            s = this.pseudoPage();
                            while (true) {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 35: {
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[35] = this.jj_gen;
                                        break block4;
                                    }
                                }
                                this.jj_consume_token(35);
                            }
                        }
                    }
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                }
            }
            this.jj_consume_token(4);
            block40: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        break block40;
                    }
                }
                this.jj_consume_token(35);
            }
            start = true;
            this.handler.startPage(t != null ? t.image : null, s);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    this.declaration();
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                }
            }
            block41: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block41;
                    }
                }
                this.jj_consume_token(8);
                block42: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block42;
                        }
                    }
                    this.jj_consume_token(35);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.declaration();
                        continue block41;
                    }
                }
                this.jj_la1[42] = this.jj_gen;
            }
            this.jj_consume_token(5);
        }
        catch (Throwable throwable) {
            if (start) {
                this.handler.endPage(t != null ? t.image : null, s);
            }
            throw throwable;
        }
        if (start) {
            this.handler.endPage(t != null ? t.image : null, s);
        }
    }

    public final String pseudoPage() throws ParseException {
        this.jj_consume_token(9);
        Token token = this.jj_consume_token(47);
        return token.image;
    }

    public final void fontFaceRule() throws ParseException {
        boolean start = false;
        try {
            this.jj_consume_token(28);
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(35);
            }
            this.jj_consume_token(4);
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        break block22;
                    }
                }
                this.jj_consume_token(35);
            }
            start = true;
            this.handler.startFontFace();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 47: {
                    this.declaration();
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                }
            }
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        break block23;
                    }
                }
                this.jj_consume_token(8);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                            break block24;
                        }
                    }
                    this.jj_consume_token(35);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.declaration();
                        continue block23;
                    }
                }
                this.jj_la1[48] = this.jj_gen;
            }
            this.jj_consume_token(5);
        }
        finally {
            if (start) {
                this.handler.endFontFace();
            }
        }
    }

    public final char combinator() throws ParseException {
        int c = 32;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 15: 
            case 20: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        c = 43;
                        break;
                    }
                    case 15: {
                        this.jj_consume_token(15);
                        c = 62;
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        c = 126;
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(35);
                }
            }
            case 35: {
                this.jj_consume_token(35);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 15: 
                    case 20: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 12: {
                                this.jj_consume_token(12);
                                c = 43;
                                break;
                            }
                            case 15: {
                                this.jj_consume_token(15);
                                c = 62;
                                break;
                            }
                            case 20: {
                                this.jj_consume_token(20);
                                c = 126;
                                break;
                            }
                            default: {
                                this.jj_la1[51] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 35: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[52] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(35);
                        }
                    }
                }
                this.jj_la1[53] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (char)c;
    }

    public final void styleRule() throws ParseException {
        SelectorList selectorList = null;
        boolean start = false;
        try {
            try {
                selectorList = this.selectorList();
                this.jj_consume_token(4);
                block20: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                            break block20;
                        }
                    }
                    this.jj_consume_token(35);
                }
                start = true;
                this.handler.startSelector(selectorList);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        this.declaration();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                block21: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block21;
                        }
                    }
                    this.jj_consume_token(8);
                    block22: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 35: {
                                break;
                            }
                            default: {
                                this.jj_la1[58] = this.jj_gen;
                                break block22;
                            }
                        }
                        this.jj_consume_token(35);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 47: {
                            this.declaration();
                            continue block21;
                        }
                    }
                    this.jj_la1[59] = this.jj_gen;
                }
                this.jj_consume_token(5);
            }
            catch (ParseException e) {
                this.skipBlock(e);
            }
        }
        finally {
            if (start) {
                this.handler.endSelector(selectorList);
            }
        }
    }

    public final SelectorList selectorList() throws ParseException {
        SelectorListImpl selectorList = new SelectorListImpl();
        Selector selector = this.selector();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(6);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(35);
            }
            selectorList.add(selector);
            selector = this.selector();
        }
        selectorList.add(selector);
        return selectorList;
    }

    public final Selector selector() throws ParseException {
        Selector selector = this.simpleSelector(null, ' ');
        while (this.jj_2_2(2)) {
            char combinator = this.combinator();
            selector = this.simpleSelector(selector, combinator);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block4;
                }
            }
            this.jj_consume_token(35);
        }
        return selector;
    }

    public final Selector simpleSelector(Selector selector, char combinator) throws ParseException {
        SimpleSelector current = null;
        Condition con = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 47: {
                current = this.elementName();
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: 
                        case 9: 
                        case 16: 
                        case 83: {
                            break;
                        }
                        default: {
                            this.jj_la1[63] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 83: {
                            con = this.hash(con);
                            continue block28;
                        }
                        case 7: {
                            con = this.clazz(con);
                            continue block28;
                        }
                        case 16: {
                            con = this.attrib(con);
                            continue block28;
                        }
                        case 9: {
                            con = this.pseudo(con);
                            continue block28;
                        }
                    }
                    break;
                }
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 7: 
            case 9: 
            case 16: 
            case 83: {
                block29: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 83: {
                            con = this.hash(con);
                            break;
                        }
                        case 7: {
                            con = this.clazz(con);
                            break;
                        }
                        case 16: {
                            con = this.attrib(con);
                            break;
                        }
                        case 9: {
                            con = this.pseudo(con);
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: 
                        case 9: 
                        case 16: 
                        case 83: {
                            continue block29;
                        }
                    }
                    break;
                }
                this.jj_la1[66] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (current == null) {
            current = this.selectorFactory.createElementSelector(null, null);
        }
        if (con != null) {
            current = this.selectorFactory.createConditionalSelector(current, con);
        }
        if (selector == null) {
            return current;
        }
        switch (combinator) {
            case ' ': {
                return this.selectorFactory.createDescendantSelector(selector, current);
            }
            case '+': {
                return this.selectorFactory.createDirectAdjacentSelector(selector.getSelectorType(), selector, current);
            }
            case '>': {
                return this.selectorFactory.createChildSelector(selector, current);
            }
            case '~': {
                return new IndirectAdjacentFilter(selector.getSelectorType(), selector, current);
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Condition clazz(Condition previous) throws ParseException {
        this.jj_consume_token(7);
        Token token = this.jj_consume_token(47);
        AttributeCondition condition = this.conditionFactory.createClassCondition(null, token.image);
        if (previous == null) {
            return condition;
        }
        return this.conditionFactory.createAndCondition(previous, (Condition)condition);
    }

    public final SimpleSelector elementName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                Token token = this.jj_consume_token(47);
                return this.selectorFactory.createElementSelector(null, token.image);
            }
            case 10: {
                this.jj_consume_token(10);
                return this.selectorFactory.createElementSelector(null, null);
            }
        }
        this.jj_la1[68] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Condition attrib(Condition previous) throws ParseException {
        Token name = null;
        Token value = null;
        int type = 0;
        this.jj_consume_token(16);
        block36: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block36;
                }
            }
            this.jj_consume_token(35);
        }
        name = this.jj_consume_token(47);
        block37: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block37;
                }
            }
            this.jj_consume_token(35);
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        type = 1;
                        break;
                    }
                    case 84: {
                        this.jj_consume_token(84);
                        type = 2;
                        break;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        type = 3;
                        break;
                    }
                    case 86: {
                        this.jj_consume_token(86);
                        type = 4;
                        break;
                    }
                    case 87: {
                        this.jj_consume_token(87);
                        type = 5;
                        break;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        type = 6;
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block38: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[72] = this.jj_gen;
                            break block38;
                        }
                    }
                    this.jj_consume_token(35);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 47: {
                        value = this.jj_consume_token(47);
                        break;
                    }
                    case 46: {
                        value = this.jj_consume_token(46);
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[74] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(35);
                }
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
            }
        }
        this.jj_consume_token(17);
        AttributeFilter condition = null;
        switch (type) {
            case 0: {
                condition = this.conditionFactory.createAttributeCondition(name.image, null, false, null);
                break;
            }
            case 1: {
                condition = this.conditionFactory.createAttributeCondition(name.image, null, false, value.image);
                break;
            }
            case 2: {
                condition = this.conditionFactory.createOneOfAttributeCondition(name.image, null, false, value.image);
                break;
            }
            case 3: {
                condition = this.conditionFactory.createBeginHyphenAttributeCondition(name.image, null, false, value.image);
                break;
            }
            case 4: {
                condition = new PrefixMatchFilter(name.image, value.image);
                break;
            }
            case 5: {
                condition = new SuffixMatchFilter(name.image, value.image);
                break;
            }
            case 6: {
                condition = new SubstringMatchFilter(name.image, value.image);
            }
        }
        if (previous == null) {
            return condition;
        }
        return this.conditionFactory.createAndCondition(previous, condition);
    }

    public final Condition pseudo(Condition previous) throws ParseException {
        Object condition = null;
        this.jj_consume_token(9);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                Token function = this.jj_consume_token(47);
                try {
                    condition = this.conditionFactory.createPseudoClassCondition(null, function.image);
                    break;
                }
                catch (CSSException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            case 92: {
                this.jj_consume_token(92);
                block25: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[76] = this.jj_gen;
                            break block25;
                        }
                    }
                    this.jj_consume_token(35);
                }
                Selector selector = this.selector();
                block26: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                            break block26;
                        }
                    }
                    this.jj_consume_token(35);
                }
                this.jj_consume_token(19);
                condition = new DenialFIlter(CSSUtil.convert(selector));
                break;
            }
            case 93: {
                Token argument;
                Token function = this.jj_consume_token(93);
                block27: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[78] = this.jj_gen;
                            break block27;
                        }
                    }
                    this.jj_consume_token(35);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        argument = this.jj_consume_token(48);
                        break;
                    }
                    case 49: {
                        argument = this.jj_consume_token(49);
                        break;
                    }
                    case 47: {
                        argument = this.jj_consume_token(47);
                        break;
                    }
                    case 46: {
                        argument = this.jj_consume_token(46);
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block28: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            break;
                        }
                        default: {
                            this.jj_la1[80] = this.jj_gen;
                            break block28;
                        }
                    }
                    this.jj_consume_token(35);
                }
                this.jj_consume_token(19);
                String name = function.image.substring(0, function.image.length() - 1);
                if (name.equals("lang")) {
                    condition = this.conditionFactory.createLangCondition(argument.image);
                    break;
                }
                if (name.equals("contains")) {
                    condition = this.conditionFactory.createContentCondition(argument.image);
                    break;
                }
                if (name.equals("nth-child")) {
                    condition = new FirstNumeralFilter(argument.image);
                    break;
                }
                if (name.equals("nth-of-type")) {
                    condition = new FirstTypedNumeralFilter(argument.image);
                    break;
                }
                if (name.equals("nth-last-child")) {
                    condition = new LastNumeralFilter(argument.image);
                    break;
                }
                if (name.equals("nth-last-of-type")) {
                    condition = new LastTypedNumeralFilter(argument.image);
                    break;
                }
                throw new ParseException("Invalid pseudo function name '" + name + "'.");
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return previous == null ? condition : this.conditionFactory.createAndCondition(previous, (Condition)condition);
    }

    public final Condition hash(Condition previous) throws ParseException {
        Token token = this.jj_consume_token(83);
        AttributeCondition condition = this.conditionFactory.createIdCondition(token.image.substring(1));
        if (previous == null) {
            return condition;
        }
        return this.conditionFactory.createAndCondition(previous, (Condition)condition);
    }

    public final void declaration() throws ParseException {
        boolean priority = false;
        try {
            String property = this.property();
            this.jj_consume_token(9);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: {
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(35);
            }
            CSSValue unit = this.expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 89: {
                    priority = this.priority();
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                }
            }
            this.handler.property(property, (LexicalUnit)unit, priority);
        }
        catch (ParseException e) {
            this.skipDeclaration(e);
        }
    }

    public final String property() throws ParseException {
        Token tokne = this.jj_consume_token(47);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(35);
        }
        return tokne.image;
    }

    public final boolean priority() throws ParseException {
        this.jj_consume_token(89);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(35);
        }
        return true;
    }

    public final CSSValue expr() throws ParseException {
        CSSValue head;
        CSSValue body = head = this.term(null);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 11: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 79: 
                case 83: 
                case 91: 
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 11: {
                    body = this.operator(body);
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                }
            }
            body = this.term(body);
        }
        return head;
    }

    public final CSSValue operator(CSSValue prev) throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                token = this.jj_consume_token(11);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[89] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(35);
        }
        return new CSSOperator(token.image, prev);
    }

    public final CSSValue term(CSSValue prev) throws ParseException {
        CSSValue value = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 93: {
                Token token;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        token = this.jj_consume_token(48);
                        value = new CSSNumber(token.image, prev);
                        break block0;
                    }
                    case 75: {
                        token = this.jj_consume_token(75);
                        value = new CSSPercentage(token.image.substring(0, token.image.length() - 1), prev);
                        break block0;
                    }
                    case 74: {
                        token = this.jj_consume_token(74);
                        value = new PixelLength(token.image, prev);
                        break block0;
                    }
                    case 68: {
                        token = this.jj_consume_token(68);
                        value = new CentimeterLength(token.image, prev);
                        break block0;
                    }
                    case 71: {
                        token = this.jj_consume_token(71);
                        value = new MillimeterLength(token.image, prev);
                        break block0;
                    }
                    case 69: {
                        token = this.jj_consume_token(69);
                        value = new InchLength(token.image, prev);
                        break block0;
                    }
                    case 73: {
                        token = this.jj_consume_token(73);
                        value = new PointLength(token.image, prev);
                        break block0;
                    }
                    case 72: {
                        token = this.jj_consume_token(72);
                        value = new PicaLength(token.image, prev);
                        break block0;
                    }
                    case 64: {
                        token = this.jj_consume_token(64);
                        value = new EMLength(token.image, prev);
                        break block0;
                    }
                    case 65: {
                        token = this.jj_consume_token(65);
                        value = new EXLength(token.image, prev);
                        break block0;
                    }
                    case 61: {
                        token = this.jj_consume_token(61);
                        value = new DegreeAngle(token.image, prev);
                        break block0;
                    }
                    case 63: {
                        token = this.jj_consume_token(63);
                        value = new RadianAngle(token.image, prev);
                        break block0;
                    }
                    case 62: {
                        token = this.jj_consume_token(62);
                        value = new GradianAngle(token.image, prev);
                        break block0;
                    }
                    case 76: {
                        token = this.jj_consume_token(76);
                        value = new MillisecondTime(token.image, prev);
                        break block0;
                    }
                    case 77: {
                        token = this.jj_consume_token(77);
                        value = new SecondTime(token.image, prev);
                        break block0;
                    }
                    case 66: {
                        token = this.jj_consume_token(66);
                        value = new HertzFrequency(token.image, prev);
                        break block0;
                    }
                    case 67: {
                        token = this.jj_consume_token(67);
                        value = new KiloHertzFrequency(token.image, prev);
                        break block0;
                    }
                    case 79: {
                        Token token2 = this.jj_consume_token(79);
                        throw new ParseException("This value '" + token2.image + "' has a unknown dimension.");
                    }
                    case 93: {
                        value = this.function(prev);
                        break block0;
                    }
                }
                this.jj_la1[90] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 46: {
                Token token = this.jj_consume_token(46);
                value = new CSSString(token.image, prev);
                break;
            }
            case 47: {
                Token token = this.jj_consume_token(47);
                if (CSSColor.isDefinedColor(token.image)) {
                    value = new CSSColor(token.image, prev);
                    break;
                }
                value = new Identifier(token.image, prev);
                break;
            }
            case 50: {
                Token token = this.jj_consume_token(50);
                value = new CSSURI(token.image, prev);
                break;
            }
            case 91: {
                value = this.rgb(prev);
                break;
            }
            case 83: {
                value = this.hexcolor(prev);
                break;
            }
            case 51: {
                Token token = this.jj_consume_token(51);
                value = new CSSUnicodeRange(token.image, prev);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block33: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block33;
                }
            }
            this.jj_consume_token(35);
        }
        return value;
    }

    public final CSSValue function(CSSValue prev) throws ParseException {
        Token token = this.jj_consume_token(93);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(35);
        }
        CSSValue params = this.expr();
        this.jj_consume_token(19);
        String function = token.image.substring(0, token.image.length() - 1);
        if (function.equals("counter")) {
            return new CounterFunction(params, prev);
        }
        if (function.equals("counters")) {
            return new CountersFunction(params, prev);
        }
        if (function.equals("attr")) {
            return new AttrFunction(params, prev);
        }
        if (function.equals("rect")) {
            return new RectFunction(params, prev);
        }
        return new CSSFunction(function, params, prev);
    }

    public final CSSValue rgb(CSSValue previous) throws ParseException {
        Token blue;
        Token green;
        Token red;
        this.jj_consume_token(91);
        block32: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block32;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                red = this.jj_consume_token(48);
                break;
            }
            case 75: {
                red = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block33: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[96] = this.jj_gen;
                    break block33;
                }
            }
            this.jj_consume_token(35);
        }
        this.jj_consume_token(6);
        block34: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[97] = this.jj_gen;
                    break block34;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                green = this.jj_consume_token(48);
                break;
            }
            case 75: {
                green = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block35: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                    break block35;
                }
            }
            this.jj_consume_token(35);
        }
        this.jj_consume_token(6);
        block36: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[100] = this.jj_gen;
                    break block36;
                }
            }
            this.jj_consume_token(35);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                blue = this.jj_consume_token(48);
                break;
            }
            case 75: {
                blue = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block37: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    break block37;
                }
            }
            this.jj_consume_token(35);
        }
        this.jj_consume_token(19);
        try {
            return new CSSColor(red.image, green.image, blue.image, previous);
        }
        catch (CSSException e) {
            throw new ParseException(e.getMessage());
        }
    }

    public final CSSValue hexcolor(CSSValue previous) throws ParseException {
        Token token = this.jj_consume_token(83);
        try {
            return new CSSColor(token.image, previous);
        }
        catch (CSSException e) {
            throw new ParseException(e.getMessage());
        }
    }

    String skip() throws ParseException, ParseException {
        int nesting = 0;
        Token token = this.getToken(0);
        StringBuffer buffer = new StringBuffer();
        if (token.image != null) {
            buffer.append(token.image);
        }
        do {
            token = this.getNextToken();
            if (token.kind == 0) break;
            buffer.append(token.image);
            if (token.kind == 4) {
                ++nesting;
                continue;
            }
            if (token.kind == 5) {
                --nesting;
                continue;
            }
            if (token.kind == 8 && nesting <= 0) break;
        } while (token.kind != 5 || nesting > 0);
        return buffer.toString();
    }

    void skipDeclaration(Exception e) throws ParseException {
        Token token = this.getToken(1);
        this.handleError("Unexpected token is appered in the declaration context, so skip to the next one.", e);
        while (token.kind != 8 && token.kind != 5 && token.kind != 0) {
            if (token.kind == 4) {
                this.skipNext();
            }
            this.getNextToken();
            token = this.getToken(1);
        }
    }

    void skipNext() throws ParseException {
        int counter = 0;
        this.getNextToken();
        Token token = this.getToken(1);
        while (token.kind != 5 || counter > 0) {
            if (token.kind == 4) {
                ++counter;
            }
            if (token.kind == 5) {
                --counter;
            }
            this.getNextToken();
            token = this.getToken(1);
        }
    }

    void skipBlock(ParseException e) throws ParseException {
        int nesting = -1;
        Token token = this.getNextToken();
        if (token.kind == 0) {
            return;
        }
        this.handleError("Unexpected token is appered in the block context, so skip to the next one.", e);
        while (token.kind != 5 || nesting > 0) {
            if (token.kind == 4) {
                ++nesting;
            } else if (token.kind == 5 && nesting > 0) {
                --nesting;
            } else if (token.kind == 0) break;
            token = this.getNextToken();
        }
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            this.jj_save(0, xla);
            return true;
        }
        {
            finally {
                this.jj_save(0, xla);
            }
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            this.jj_save(1, xla);
            return true;
        }
        {
            finally {
                this.jj_save(1, xla);
            }
        }
    }

    private final boolean jj_3R_68() {
        Token xsp;
        if (this.jj_3R_74()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_74());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_78() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_73();
    }

    private final boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_79()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_72() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_76()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_77()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_69() {
        return this.jj_scan_token(12);
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_71()) {
                    return true;
                }
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(35));
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_1() {
        Token xsp;
        if (this.jj_scan_token(47)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(35));
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_63()) {
            return true;
        }
        return this.jj_3R_64();
    }

    private final boolean jj_3R_81() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_71() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_87() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_86() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_84() {
        return this.jj_scan_token(83);
    }

    private final boolean jj_3R_83() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_79() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_80() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_70() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_81()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_82()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_83()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        int[] nArray = new int[103];
        nArray[2] = 256;
        nArray[5] = -268368256;
        nArray[8] = 0x4000000;
        nArray[11] = 0x20000000;
        nArray[14] = -805239168;
        nArray[15] = -805239168;
        nArray[24] = -2147416448;
        nArray[25] = 64;
        nArray[27] = -2147416448;
        nArray[29] = -2147416448;
        nArray[30] = -2147416448;
        nArray[36] = 512;
        nArray[37] = 512;
        nArray[40] = 256;
        nArray[46] = 256;
        nArray[49] = 0x109000;
        nArray[51] = 0x109000;
        nArray[53] = 0x109000;
        nArray[54] = 0x109000;
        nArray[57] = 256;
        nArray[60] = 64;
        nArray[63] = 66176;
        nArray[64] = 66176;
        nArray[65] = 66176;
        nArray[66] = 66176;
        nArray[67] = 67200;
        nArray[68] = 1024;
        nArray[71] = 16384;
        nArray[75] = 16384;
        nArray[86] = 2112;
        nArray[87] = 2112;
        nArray[88] = 2112;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_1() {
        int[] nArray = new int[103];
        nArray[0] = 8;
        nArray[1] = 32768;
        nArray[3] = 8;
        nArray[4] = 32768;
        nArray[5] = 32772;
        nArray[6] = 8;
        nArray[7] = 8;
        nArray[9] = 8;
        nArray[10] = 8;
        nArray[12] = 8;
        nArray[13] = 8;
        nArray[14] = 32772;
        nArray[15] = 32772;
        nArray[16] = 8;
        nArray[17] = 8;
        nArray[18] = 8;
        nArray[19] = 278528;
        nArray[20] = 8;
        nArray[21] = 32768;
        nArray[22] = 8;
        nArray[23] = 8;
        nArray[24] = 32772;
        nArray[26] = 8;
        nArray[27] = 32772;
        nArray[28] = 8;
        nArray[29] = 32772;
        nArray[30] = 32772;
        nArray[31] = 8;
        nArray[32] = 8;
        nArray[33] = 8;
        nArray[34] = 8;
        nArray[35] = 8;
        nArray[36] = 32768;
        nArray[37] = 32768;
        nArray[38] = 8;
        nArray[39] = 32768;
        nArray[41] = 8;
        nArray[42] = 32768;
        nArray[43] = 8;
        nArray[44] = 8;
        nArray[45] = 32768;
        nArray[47] = 8;
        nArray[48] = 32768;
        nArray[50] = 8;
        nArray[52] = 8;
        nArray[54] = 8;
        nArray[55] = 8;
        nArray[56] = 32768;
        nArray[58] = 8;
        nArray[59] = 32768;
        nArray[61] = 8;
        nArray[62] = 8;
        nArray[67] = 32768;
        nArray[68] = 32768;
        nArray[69] = 8;
        nArray[70] = 8;
        nArray[72] = 8;
        nArray[73] = 49152;
        nArray[74] = 8;
        nArray[76] = 8;
        nArray[77] = 8;
        nArray[78] = 8;
        nArray[79] = 245760;
        nArray[80] = 8;
        nArray[81] = 32768;
        nArray[82] = 8;
        nArray[84] = 8;
        nArray[85] = 8;
        nArray[86] = -535969792;
        nArray[89] = 8;
        nArray[90] = -536805376;
        nArray[91] = -535969792;
        nArray[92] = 8;
        nArray[93] = 8;
        nArray[94] = 8;
        nArray[95] = 65536;
        nArray[96] = 8;
        nArray[97] = 8;
        nArray[98] = 65536;
        nArray[99] = 8;
        nArray[100] = 8;
        nArray[101] = 65536;
        nArray[102] = 8;
        jj_la1_1 = nArray;
    }

    private static void jj_la1_2() {
        int[] nArray = new int[103];
        nArray[5] = 524288;
        nArray[9] = 393216;
        nArray[10] = 393216;
        nArray[12] = 393216;
        nArray[13] = 393216;
        nArray[14] = 524288;
        nArray[15] = 524288;
        nArray[16] = 393216;
        nArray[17] = 393216;
        nArray[24] = 524288;
        nArray[27] = 524288;
        nArray[29] = 524288;
        nArray[30] = 524288;
        nArray[63] = 524288;
        nArray[64] = 524288;
        nArray[65] = 524288;
        nArray[66] = 524288;
        nArray[67] = 524288;
        nArray[71] = 0x1F00000;
        nArray[75] = 0x1F00000;
        nArray[81] = 0x30000000;
        nArray[83] = 0x2000000;
        nArray[86] = 671662015;
        nArray[90] = 536919999;
        nArray[91] = 671662015;
        nArray[95] = 2048;
        nArray[98] = 2048;
        nArray[101] = 2048;
        jj_la1_2 = nArray;
    }

    public CueryParser(InputStream stream) {
        this(stream, null);
    }

    public CueryParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public CueryParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public CueryParser(CueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(CueryParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 103) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[95];
        int i = 0;
        while (i < 95) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 103) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 95) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private static final class LookaheadSuccess
    extends Error {
        LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

