/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import junit.framework.TestCase;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSURI;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ListStyleDefinitionTest.java,v 1.0 2005/09/01 5:51:56 Teletha Exp $
 */
public class ListStyleDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.ListStyleDefinition.parse(CSSValue)'
     */
    public void testParse1() {
        CSSValue value = new Identifier("decimal", null);
        CSSValue value2 = new Identifier("inside", value);
        new CSSURI("http://test.org/", value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("list-style", value, false);

        assertEquals("decimal", property.getValueAsString("list-style-type"));
        assertEquals("inside", property.getValueAsString("list-style-position"));
        assertEquals("http://test.org/", property.getValueAsString("list-style-image"));

        assertEquals("decimal inside url(\"http://test.org/\")", CSSUtil.toString(property.getValue("list-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.ListStyleDefinition.parse(CSSValue)'
     */
    public void testParse2() {
        CSSValue value = new Identifier("none", null);
        new Identifier("inside", value);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("list-style", value, false);

        assertEquals("none", property.getValueAsString("list-style-type"));
        assertEquals("inside", property.getValueAsString("list-style-position"));
        assertEquals("none", property.getValueAsString("list-style-image"));

        assertEquals("none inside", CSSUtil.toString(property.getValue("list-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.ListStyleDefinition.parse(CSSValue)' whether
     * 'inherit' identifier is acceptable or not.
     */
    public void testParse3() {
        // test inherit
        CSSValue value = new Identifier("inherit", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("list-style", value, false);

        assertEquals("inherit", property.getValueAsString("list-style-type"));
        assertEquals("inherit", property.getValueAsString("list-style-position"));
        assertEquals("inherit", property.getValueAsString("list-style-image"));

        assertEquals("inherit", CSSUtil.toString(property.getValue("list-style")));
    }

    /*
     * Test method for 'org.trix.cuery.property.css2.ListStyleDefinition.parse(CSSValue)' with a
     * invalid value.
     */
    public void testParse4() {
        CSSValue value = new Identifier("inside", null);
        new Identifier("outside", value);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("list-style", value, false);

        assertNull(property.getValueAsString("list-style-type"));
        assertNull(property.getValueAsString("list-style-position"));
        assertNull(property.getValueAsString("list-style-image"));
        assertNull(property.getValue("list-style"));
    }

}
