/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.w3c.css.sac.CSSException;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: RectFunction.java,v 1.0 2005/08/09 22:44:18 Teletha Exp $
 */
public class RectFunction extends CSSFunction implements Rect {

    /**
     * Create RectFunction instance.
     * 
     * @param expression A expression.
     * @param previous A previous value.
     * @throws CSSException If this function is invalid.
     */
    public RectFunction(CSSValue expression, CSSValue previous) throws CSSException {
        super("rect", expression, previous);

        // check length
        if (expression.getLength() != 7) {
            throw new CSSException("This expression is invalid fo this rect function.");
        }
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_RECT_FUNCTION;
    }

    /**
     * @see org.trix.cuery.value.CSSFunction#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_RECT;
    }

    /**
     * @see org.w3c.dom.css.Rect#getBottom()
     */
    public CSSPrimitiveValue getBottom() {
        return (CSSPrimitiveValue) params.item(4);
    }

    /**
     * @see org.w3c.dom.css.Rect#getLeft()
     */
    public CSSPrimitiveValue getLeft() {
        return (CSSPrimitiveValue) params.item(6);
    }

    /**
     * @see org.w3c.dom.css.Rect#getRight()
     */
    public CSSPrimitiveValue getRight() {
        return (CSSPrimitiveValue) params.item(2);
    }

    /**
     * @see org.w3c.dom.css.Rect#getTop()
     */
    public CSSPrimitiveValue getTop() {
        return (CSSPrimitiveValue) params.item(0);
    }

    /**
     * @see org.trix.cuery.value.AbstractCSSValue#getRectValue()
     */
    public Rect getRectValue() throws DOMException {
        return this;
    }

}
