/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;


import org.w3c.css.sac.Condition;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ClassFilter.java,v 1.0 2005/07/26 1:50:55 Teletha Exp $
 */
public class ClassFilter extends TokensFilter {

    /**
     * Create ClassFilter instance.
     * 
     * @param className A class name.
     */
    public ClassFilter(String className) {
        super("class", className);
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return Condition.SAC_CLASS_CONDITION;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "." + value;
    }
}
