/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSValue;

public class ShorthandPropertyDefinition
extends PropertyDefinition {
    protected final List definitions = new ArrayList(4);

    protected void addAcceptable(Object acceptable) {
        if (acceptable instanceof PropertyDefinition) {
            this.definitions.add(acceptable);
        } else {
            super.addAcceptable(acceptable);
        }
    }

    public Map parse(CSSValue value) {
        if (value.getLength() == 1 && value.getLexicalUnitType() == 12) {
            if (!this.acceptInherit()) {
                return null;
            }
            HashMap<String, CSSValue> map = new HashMap<String, CSSValue>(this.definitions.size());
            int i = 0;
            while (i < this.definitions.size()) {
                PropertyDefinition definition = (PropertyDefinition)this.definitions.get(i);
                Map result = definition.parse(value);
                if (result != null) {
                    map.putAll(result);
                    map.put(definition.getName(), value);
                }
                ++i;
            }
            return map;
        }
        HashMap<String, CSSValue> map = new HashMap<String, CSSValue>(this.definitions.size());
        CSSValue current = value;
        boolean[] flags = new boolean[this.definitions.size()];
        Arrays.fill(flags, false);
        block1: while (current != null) {
            short type = current.getLexicalUnitType();
            if (type == 12) {
                return null;
            }
            if (type == 4) {
                current = current.getNextValue();
                continue;
            }
            if (type == 0) break;
            int i = 0;
            while (i < this.definitions.size()) {
                if (flags[i]) {
                    if (i == this.definitions.size() - 1) {
                        return null;
                    }
                } else {
                    Map result = null;
                    PropertyDefinition definition = (PropertyDefinition)this.definitions.get(i);
                    result = definition instanceof ShorthandPropertyDefinition ? definition.parse(CSSUtil.singleValue(current)) : definition.parse(current);
                    if (result == null) {
                        if (i == this.definitions.size() - 1) {
                            return null;
                        }
                    } else {
                        map.putAll(result);
                        map.put(definition.getName(), current);
                        flags[i] = true;
                        current = current.getNextValue();
                        continue block1;
                    }
                }
                ++i;
            }
        }
        return this.validate(map);
    }

    protected Map validate(Map result) {
        return result;
    }

    private boolean acceptInherit() {
        int i = 0;
        while (i < this.acceptables.size()) {
            if (this.acceptables.get(i).equals("inherit")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

