/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSRectFunctionTest.java,v 1.0 2005/08/10 15:35:53 Teletha Exp $
 */
public class CSSRectFunctionTest extends TestCase {

    private static CSSRectFunction rect;

    static {
        Value top = new CSSemLength("3.2", null);
        Value comma1 = new CSSOperator(",", top);
        Value right = new CSSpxLength("20", comma1);
        Value comma2 = new CSSOperator(",", right);
        Value bottom = new CSSemLength("-2", comma2);
        Value comma3 = new CSSOperator(",", bottom);
        new CSSemLength("0", comma3);

        rect = new CSSRectFunction(top, null);
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSRectFunction.getBottom()'
     */
    public void testGetBottom() {
        assertEquals("-2em", rect.getBottom().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSRectFunction.getLeft()'
     */
    public void testGetLeft() {
        assertEquals("0em", rect.getLeft().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSRectFunction.getRight()'
     */
    public void testGetRight() {
        assertEquals("20px", rect.getRight().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSRectFunction.getTop()'
     */
    public void testGetTop() {
        assertEquals("3.2em", rect.getTop().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSFunction.getCssText()'
     */
    public void testGetCssText() {
        assertEquals("rect(3.2em,20px,-2em,0em)", rect.getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSFunction.getStringValue()'
     */
    public void testGetStringValue() {
        assertEquals("3.2em,20px,-2em,0em", rect.getStringValue());
    }

}
