/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;


/**
 * DOCUMENT.
 *
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSCountersFunctionTest.java,v 1.0 2005/08/10 16:24:05 Teletha Exp $
 */
public class CSSCountersFunctionTest extends TestCase {
    private static CSSCountersFunction counter;

    static {
        Value name = new CSSIdent("section", null);
        Value comma1 = new CSSOperator(",", name);
        new CSSString("-", comma1);

        counter = new CSSCountersFunction(name, null);
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getIdentifier()'
     */
    public void testGetIdentifier() {
        assertEquals("section", counter.getIdentifier());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getListStyle()'
     */
    public void testGetListStyle() {
        assertEquals(null, counter.getListStyle());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getSeparator()'
     */
    public void testGetSeparator() {
        assertEquals("-", counter.getSeparator());
    }

}
