/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;


/**
 * DOCUMENT.
 *
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSCounterFunctionTest.java,v 1.0 2005/08/10 16:18:45 Teletha Exp $
 */
public class CSSCounterFunctionTest extends TestCase {
    
    private static CSSCounterFunction counter;

    static {
        Value name = new CSSIdent("section", null);
        Value comma1 = new CSSOperator(",", name);
        new CSSIdent("upper-latin", comma1);

        counter = new CSSCounterFunction(name, null);
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getIdentifier()'
     */
    public void testGetIdentifier() {
        assertEquals("section", counter.getIdentifier());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getListStyle()'
     */
    public void testGetListStyle() {
        assertEquals("upper-latin", counter.getListStyle());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSCounterFunction.getSeparator()'
     */
    public void testGetSeparator() {
        assertEquals(null, counter.getSeparator());
    }

}
