/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.css;

import junit.framework.TestCase;

import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.css.CSSPipe;
import org.trix.cuery.css.ValidatableCSSPipe;
import org.trix.cuery.parser.CueryParser;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.LexicalUnit;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ValidatableCSSPipeTest.java,v 1.0 2005/08/10 2:09:07 Teletha Exp $
 */
public class ValidatableCSSPipeTest extends TestCase {

    /** The test parser. */
    private static CueryParser parser;

    private static TestConsumer consumer = new TestConsumer();

    private static CSSPipe pipe = new ValidatableCSSPipe();

    // initialize
    static {
        parser = new CueryParser();

        pipe.setConsumer(consumer);
        parser.setDocumentHandler(pipe);
    }

    /*
     * Test method for 'org.trix.cuery.css.ValidatableCSSPipe.property(String, LexicalUnit, boolean)'
     */
    public void testColor() throws Exception {
        parser.parseStyleSheet("src/test/org/trix/cuery/css/color.css");
        assertEquals(7, consumer.getCount());
    }

    /*
     * Test method for 'org.trix.cuery.css.ValidatableCSSPipe.property(String, LexicalUnit, boolean)'
     */
    public void testBackgroundColor() throws Exception {
        parser.parseStyleSheet("src/test/org/trix/cuery/css/background-color.css");
        assertEquals(3, consumer.getCount());
    }

    /**
     * DOCUMENT.
     * 
     * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
     * @version $ Id: TestConsumer.java,v 1.0 2005/08/10 2:57:29 Teletha Exp $
     */
    private static class TestConsumer extends AbstractCSSConsumer {

        private int count = 0;

        /**
         * @see org.trix.cuery.css.ValidatableCSSPipe#property(java.lang.String,
         *      org.w3c.css.sac.LexicalUnit, boolean)
         */
        @Override
        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            count++;
        }

        private int getCount() {
            int i = count;
            count = 0;
            return i;
        }
    }

}
