/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import java.io.IOException;

import junit.framework.TestCase;

import org.trix.cuery.style.Style;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSWeaverTest.java,v 1.01 2005/08/14 18:47:39 Teletha Exp $
 */
public class CSSWeaverTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply1() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.addAuthorStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverAuthor.css"));
        weaver.addUserStylesheet(CSSUtil.getSource("src/test/org/trix/cuery/cssWeaverUser.css"));
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element heading1 = DOMUtil.getElementById(document, "heading1");
        Style style = (Style) heading1.getUserData(Style.KEY);
        assertEquals("1em", style.getProperty("text-indent"));
        assertEquals("2em", style.getProperty("font-size"));
        assertEquals("italic", style.getProperty("font-style"));
        assertEquals("normal", style.getProperty("font-weight"));

        Element p = DOMUtil.getElementById(document, "p");
        style = (Style) p.getUserData(Style.KEY);
        // check position weight
        assertEquals("0.9em", style.getProperty("font-size"));
    }

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply2() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.awareXmlStylesheet(true);
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaverInline.xml");

        Element heading1 = DOMUtil.getElementById(document, "heading1");
        Style style = (Style) heading1.getUserData(Style.KEY);
        assertEquals("1em", style.getProperty("text-indent"));
        assertEquals("1em", style.getProperty("font-size"));
        assertEquals("italic", style.getProperty("font-style"));
        assertEquals("normal", style.getProperty("font-weight"));

        Element p = DOMUtil.getElementById(document, "p");
        style = (Style) p.getUserData(Style.KEY);
        // check position weight
        assertEquals("0.9em", style.getProperty("font-size"));
    }

    /*
     * Test method for 'org.trix.cuery.CSSWeaver.apply(Document)'
     */
    public void testApply3() throws IOException {
        CSSWeaver weaver = new CSSWeaver();
        weaver.awareXmlStylesheet(true);
        Document prev = weaver.apply("src/test/org/trix/cuery/cssWeaverInline.xml");

        // next document with no style
        Document document = weaver.apply("src/test/org/trix/cuery/cssWeaver.xml");

        Element p = DOMUtil.getElementById(document, "p");
        Style style = (Style) p.getUserData(Style.KEY);
        assertNull(style);

        p = DOMUtil.getElementById(prev, "p");
        style = (Style) p.getUserData(Style.KEY);
        assertNotNull(style);
    }
}
