/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSIdent.java,v 1.0 2005/08/09 22:02:28 Teletha Exp $
 */
public class CSSIdent extends AbstractValue {

    /**
     * Create CSSIdent instance.
     * 
     * @param ident A identifier value.
     * @param previous A previous value of this value.
     */
    public CSSIdent(String ident, Value previous) {
        super(previous);

        this.stringValue = ident;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        if (INHERIT.equalsIgnoreCase(stringValue)) {
            return SAC_INHERIT;
        } else {
            return SAC_IDENT;
        }
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        throw new UnsupportedOperationException(getClass().getSimpleName() + " can't execute this method.");
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.trix.cuery.value.AbstractValue#getCssValueType()
     */
    public short getCssValueType() {
        if (INHERIT.equalsIgnoreCase(stringValue)) {
            return CSS_INHERIT;
        } else {
            return super.getCssValueType();
        }
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        if (INHERIT.equalsIgnoreCase(stringValue)) {
            return CSS_INHERIT;
        } else {
            return CSS_IDENT;
        }
    }
}
