/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractCSSLength.java,v 1.0 2005/08/09 10:33:44 Teletha Exp $
 */
public abstract class AbstractCSSLength extends AbstractValue implements CSSLength {

    /**
     * Create AbstractCSSLength instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public AbstractCSSLength(String length, Value previous) {
        super(previous);

        this.stringValue = length;
        this.floatValue = Float.parseFloat(length);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        return floatValue;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.trix.cuery.value.AbstractValue#getDimensionUnitText()
     */
    @Override
    public String getDimensionUnitText() {
        return getClass().getSimpleName().substring(3, 5);
    }

    /**
     * @see org.trix.cuery.value.AbstractValue#getCssText()
     */
    @Override
    public String getCssText() {
        return stringValue + getDimensionUnitText();
    }
}
