/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.style;

import org.trix.cuery.value.Value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractStyle.java,v 1.0 2005/08/10 22:24:25 Teletha Exp $
 */
public abstract class AbstractStyle implements Style {

    /**
     * @see org.trix.cuery.style.Style#getProperty(java.lang.String)
     */
    public String getProperty(String name) {
        return getProperty(name, null);
    }

    /**
     * @see org.trix.cuery.style.Style#getProperty(java.lang.String, java.lang.String)
     */
    public String getProperty(String name, String defaultValue) {
        Value value = getPropertyValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getCssText();
    }

    /**
     * @see org.trix.cuery.style.Style#getPropertyAsFloat(java.lang.String)
     */
    public float getPropertyAsFloat(String name) {
        return getPropertyAsFloat(name, 0);
    }

    /**
     * @see org.trix.cuery.style.Style#getPropertyAsFloat(java.lang.String, int)
     */
    public float getPropertyAsFloat(String name, int defaultValue) {
        Value value = getPropertyValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getFloatValue();
    }

    /**
     * @see org.trix.cuery.style.Style#getPropertyAsInteger(java.lang.String)
     */
    public int getPropertyAsInteger(String name) {
        return getPropertyAsInteger(name, 0);
    }

    /**
     * @see org.trix.cuery.style.Style#getPropertyAsInteger(java.lang.String, int)
     */
    public int getPropertyAsInteger(String name, int defaultValue) {
        Value value = getPropertyValue(name);

        if (value == null) {
            return defaultValue;
        }
        return value.getIntegerValue();
    }

}
