/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.sac;

import java.util.ArrayList;
import java.util.List;

import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SelectorListImpl.java,v 1.0 2005/07/29 12:54:55 Teletha Exp $
 */
public class SelectorListImpl implements SelectorList {

    /** The actual list. */
    private List<Selector> list = new ArrayList<Selector>(8);

    /**
     * @see org.w3c.css.sac.SelectorList#getLength()
     */
    public int getLength() {
        return list.size();
    }

    /**
     * @see org.w3c.css.sac.SelectorList#item(int)
     */
    public Selector item(int position) {
        return list.get(position);
    }

    /**
     * Add a selector to this list.
     * 
     * @param selector A selector to put.
     */
    public void add(Selector selector) {
        // check null
        if (selector == null) {
            return;
        }
        list.add(selector);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return list.toString();
    }

}
