/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import java.util.Set;

import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ProcessingFilter.java,v 1.0 2005/08/04 15:19:32 Teletha Exp $
 */
public interface ProcessingFilter extends Filter {

    /**
     * Return parent selector.
     * 
     * @return A parent selector.
     */
    Selector getSelector();

    /**
     * Return current selector.
     * 
     * @return A current selector.
     */
    SimpleSelector getSimpleSelector();

    /**
     * Process path.
     * 
     * @param container A element container.
     * @param source A source element.
     */
    void process(Set<Element> container, Element source);
}
