/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import java.util.Set;

import org.trix.cuery.util.DOMUtil;

import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: DescendantFilter.java,v 1.0 2005/07/29 12:28:29 Teletha Exp $
 */
public class DescendantFilter extends ChildFilter {

    /**
     * Create DescendantFilter instance.
     * 
     * @param parent A parent selector.
     * @param simpleSelector A current selector.
     */
    public DescendantFilter(Selector parent, SimpleSelector simpleSelector) {
        super(parent, simpleSelector);
    }

    /**
     * @see org.trix.cuery.filter.ChildFilter#process(java.util.Set, org.w3c.dom.Element)
     */
    public void process(Set<Element> container, Element source) {
        container.addAll(DOMUtil.retrieveElements(source, current, true));
    }

    /**
     * @see org.trix.cuery.filter.ChildFilter#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_DESCENDANT_SELECTOR;
    }

    /**
     * @see org.trix.cuery.filter.ChildFilter#toString()
     */
    public String toString() {
        return parent + " " + current;
    }
}
