/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import java.util.HashMap;
import java.util.Map;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: MediaType.java,v 1.0 2005/08/05 18:24:24 Teletha Exp $
 */
public final class MediaType {

    /** The media type pool. */
    private static final Map<String, MediaType> MEDIATYPES = new HashMap<String, MediaType>();

    /** The all media type. */
    public static final MediaType ALL = new MediaType("all");

    /** The aural media type. */
    public static final MediaType AURAL = new MediaType("aural");

    /** The braille media type. */
    public static final MediaType BRAILLE = new MediaType("braille");

    /** The emboss media type. */
    public static final MediaType EMBOSSED = new MediaType("embossed");

    /** The handheld media type. */
    public static final MediaType HANDHELD = new MediaType("handheld");

    /** The print media type. */
    public static final MediaType PRINT = new MediaType("print");

    /** The projection media type. */
    public static final MediaType PROJECTION = new MediaType("projection");

    /** The screen media type. */
    public static final MediaType SCREEN = new MediaType("screen");

    /** The tty media type. */
    public static final MediaType TTY = new MediaType("tty");

    /** The tv media type. */
    public static final MediaType TV = new MediaType("tv");

    /** The media type. */
    private String type;

    /**
     * Construct a new MediaType instance.
     * 
     * @param type A media type.
     */
    private MediaType(String type) {
        this.type = type;
        MEDIATYPES.put(type, this);
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return type;
    }

    /**
     * DOCUMENT.
     * 
     * @param type A type candidate.
     * @return Whether the media type is exist or not.
     */
    public static boolean isMediaType(String type) {
        return MEDIATYPES.containsKey(type);
    }
}
